/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

public final class JsonLongImpl
implements JsonNumber,
Serializable {
    private final long value;
    private Integer hashCode = null;

    JsonLongImpl(long value) {
        this.value = value;
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public int intValueExact() {
        int intVal = this.intValue();
        if ((long)intVal != this.value) {
            throw new ArithmeticException("Overflow");
        }
        return intVal;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public long longValueExact() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return new BigInteger(this.toString());
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return this.bigIntegerValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.toString());
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.bigDecimalValue().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (JsonLongImpl.class.isInstance(obj)) {
            return ((JsonLongImpl)JsonLongImpl.class.cast((Object)obj)).value == this.value;
        }
        return JsonNumber.class.isInstance(obj) && ((JsonNumber)JsonNumber.class.cast(obj)).bigDecimalValue().equals(this.bigDecimalValue());
    }
}

