/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.synccontext.named;

import shaded.org.eclipse.aether.internal.impl.synccontext.named.BasedirNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.DiscriminatingNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.GAECVNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.GAVNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.HashingNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.StaticNameMapper;

public final class NameMappers {
    public static final String STATIC_NAME = "static";
    public static final String GAV_NAME = "gav";
    public static final String FILE_GAV_NAME = "file-gav";
    public static final String FILE_HGAV_NAME = "file-hgav";
    public static final String GAECV_NAME = "gaecv";
    public static final String FILE_GAECV_NAME = "file-gaecv";
    public static final String FILE_HGAECV_NAME = "file-hgaecv";
    public static final String FILE_STATIC_NAME = "file-static";
    public static final String DISCRIMINATING_NAME = "discriminating";

    private NameMappers() {
    }

    public static NameMapper staticNameMapper() {
        return new StaticNameMapper();
    }

    public static NameMapper gavNameMapper() {
        return NameMappers.gavNameMapper(false);
    }

    public static NameMapper gavNameMapper(boolean fileSystemFriendly) {
        if (fileSystemFriendly) {
            return new GAVNameMapper(true, "artifact~", ".lock", "metadata~", ".lock", "~");
        }
        return new GAVNameMapper(false, "artifact:", "", "metadata:", "", ":");
    }

    public static NameMapper gaecvNameMapper() {
        return NameMappers.gaecvNameMapper(false);
    }

    public static NameMapper gaecvNameMapper(boolean fileSystemFriendly) {
        if (fileSystemFriendly) {
            return new GAECVNameMapper(true, "artifact~", ".lock", "metadata~", ".lock", "~");
        }
        return new GAECVNameMapper(false, "artifact:", "", "metadata:", "", ":");
    }

    public static NameMapper fileGavNameMapper() {
        return new BasedirNameMapper(NameMappers.gavNameMapper(true));
    }

    public static NameMapper fileGaecvNameMapper() {
        return new BasedirNameMapper(NameMappers.gaecvNameMapper(true));
    }

    public static NameMapper fileStaticNameMapper() {
        return new BasedirNameMapper(new StaticNameMapper());
    }

    public static NameMapper fileHashingGavNameMapper() {
        return new BasedirNameMapper(new HashingNameMapper(NameMappers.gavNameMapper(false)));
    }

    public static NameMapper fileHashingGaecvNameMapper() {
        return new BasedirNameMapper(new HashingNameMapper(NameMappers.gaecvNameMapper(false)));
    }

    public static NameMapper discriminatingNameMapper() {
        return new DiscriminatingNameMapper(NameMappers.gavNameMapper(false));
    }
}

