/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connection.utils;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.utils.AbstractConnectionHandle;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnectionFactory;
import org.ops4j.pax.transx.connection.utils.CredentialExtractor;
import org.ops4j.pax.transx.connection.utils.UserPasswordManagedConnectionFactory;

public abstract class AbstractManagedConnection<MCF extends AbstractManagedConnectionFactory<MCF, MC, C, CI>, MC extends AbstractManagedConnection<MCF, MC, C, CI>, C, CI extends AbstractConnectionHandle<MCF, MC, C, CI>>
implements ManagedConnection {
    protected final MCF mcf;
    protected CI handle;
    protected LinkedList<CI> handles;
    protected ArrayDeque<ConnectionEventListener> listeners;
    protected final CredentialExtractor credentialExtractor;
    protected final ExceptionSorter exceptionSorter;
    protected final LocalTransactionImpl localTx;
    protected final LocalTransactionImpl localClientTx;
    protected PrintWriter log;
    protected Subject subject;
    protected ConnectionRequestInfo cri;
    protected XAResource xaResource;
    protected boolean inXaTransaction;
    private ConnectionEventListener listener;

    public AbstractManagedConnection(MCF mcf, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter) {
        assert (exceptionSorter != null);
        this.mcf = mcf;
        this.credentialExtractor = credentialExtractor;
        this.exceptionSorter = exceptionSorter;
        this.localTx = new LocalTransactionImpl(true);
        this.localClientTx = new LocalTransactionImpl(false);
    }

    public MCF getMCF() {
        return this.mcf;
    }

    public LocalTransaction getClientLocalTransaction() {
        return this.localClientTx;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTx;
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.xaResource == null) {
            throw new NotSupportedException("XAResource not available");
        }
        return new XAResourceProxy();
    }

    protected CredentialExtractor getCredentialExtractor() {
        return this.credentialExtractor;
    }

    protected abstract boolean isValid();

    public void cleanup() throws ResourceException {
        if (this.handle != null) {
            ((AbstractConnectionHandle)this.handle).cleanup();
            this.handle = null;
        }
        if (this.handles != null) {
            this.handles.forEach(AbstractConnectionHandle::cleanup);
            this.handles = null;
        }
    }

    public void destroy() throws ResourceException {
        this.cleanup();
        this.listener = null;
        this.listeners = null;
        this.closePhysicalConnection();
    }

    public void associateConnection(Object o) {
        throw new UnsupportedOperationException();
    }

    public void connectionClosed(CI handle) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle(handle);
        if (this.listeners != null) {
            for (ConnectionEventListener listener : AbstractManagedConnection.reverse(this.listeners)) {
                listener.connectionClosed(event);
            }
        }
        if (this.listener != null) {
            this.listener.connectionClosed(event);
        }
    }

    public void connectionError(Exception e) {
        if (this.exceptionSorter.isExceptionFatal(e)) {
            if (this.exceptionSorter.rollbackOnFatalException()) {
                this.attemptRollback();
            }
            this.unfilteredConnectionError(e);
        }
    }

    protected void attemptRollback() {
    }

    protected void unfilteredConnectionError(Exception e) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, e);
        if (this.listeners != null) {
            for (ConnectionEventListener listener : AbstractManagedConnection.reverse(this.listeners)) {
                listener.connectionErrorOccurred(event);
            }
        }
        if (this.listener != null) {
            this.listener.connectionErrorOccurred(event);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.listener == null) {
            this.listener = connectionEventListener;
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayDeque();
            }
            this.listeners.add(connectionEventListener);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.listener == connectionEventListener) {
            this.listener = null;
            if (this.listeners != null) {
                this.listener = this.listeners.removeFirst();
            }
        } else if (this.listeners != null) {
            this.listeners.remove(connectionEventListener);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.log;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.log = printWriter;
    }

    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
            if (this.listeners != null) {
                for (ConnectionEventListener listener : AbstractManagedConnection.reverse(this.listeners)) {
                    listener.localTransactionStarted(event);
                }
            }
            if (this.listener != null) {
                this.listener.localTransactionStarted(event);
            }
        }
    }

    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
            if (this.listeners != null) {
                for (ConnectionEventListener listener : AbstractManagedConnection.reverse(this.listeners)) {
                    listener.localTransactionCommitted(event);
                }
            }
            if (this.listener != null) {
                this.listener.localTransactionCommitted(event);
            }
        }
    }

    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
            if (this.listener != null) {
                this.listener.localTransactionRolledback(event);
            }
            if (this.listeners != null) {
                for (ConnectionEventListener listener : this.listeners) {
                    listener.localTransactionRolledback(event);
                }
            }
        }
    }

    protected void setInXaTransaction(boolean inXaTransaction) {
        this.inXaTransaction = inXaTransaction;
    }

    public boolean isInXaTransaction() {
        return this.inXaTransaction;
    }

    public abstract C getPhysicalConnection();

    protected abstract void closePhysicalConnection() throws ResourceException;

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        String userName = this.credentialExtractor.getUserName();
        CredentialExtractor credential = new CredentialExtractor(subject, connectionRequestInfo, (UserPasswordManagedConnectionFactory)this.mcf);
        if (userName != null && !userName.equals(credential.getUserName())) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (userName == null && credential.getUserName() != null) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        Object handle = ((AbstractManagedConnectionFactory)this.mcf).createConnectionHandle(connectionRequestInfo, (AbstractManagedConnection)this);
        if (this.handle == null) {
            this.handle = handle;
        } else {
            if (this.handles == null) {
                this.handles = new LinkedList();
            }
            this.handles.add(handle);
        }
        this.subject = subject;
        this.cri = connectionRequestInfo;
        return handle;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new ManagedConnectionMetaData(){

            public String getEISProductName() throws ResourceException {
                return null;
            }

            public String getEISProductVersion() throws ResourceException {
                return null;
            }

            public int getMaxConnections() throws ResourceException {
                return -1;
            }

            public String getUserName() throws ResourceException {
                return AbstractManagedConnection.this.credentialExtractor.getUserName();
            }
        };
    }

    private static <S> Iterable<S> reverse(Deque<S> col) {
        if (col.size() <= 1) {
            return col;
        }
        return col::descendingIterator;
    }

    class XAResourceProxy
    implements XAResource {
        XAResourceProxy() {
        }

        private XAResource getXAResource() {
            return AbstractManagedConnection.this.xaResource;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            this.getXAResource().start(xid, flags);
            AbstractManagedConnection.this.setInXaTransaction(true);
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            this.getXAResource().commit(xid, onePhase);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            this.getXAResource().rollback(xid);
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            try {
                this.getXAResource().end(xid, flags);
            }
            finally {
                AbstractManagedConnection.this.setInXaTransaction(false);
            }
        }

        @Override
        public void forget(Xid xid) throws XAException {
            this.getXAResource().forget(xid);
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return this.getXAResource().getTransactionTimeout();
        }

        @Override
        public boolean isSameRM(XAResource xaResource) throws XAException {
            XAResource xares = xaResource;
            if (xaResource instanceof XAResourceProxy) {
                xares = ((XAResourceProxy)xaResource).getXAResource();
            }
            return this.getXAResource().isSameRM(xares);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            return this.getXAResource().prepare(xid);
        }

        @Override
        public Xid[] recover(int flags) throws XAException {
            return this.getXAResource().recover(flags);
        }

        @Override
        public boolean setTransactionTimeout(int timeout) throws XAException {
            return this.getXAResource().setTransactionTimeout(timeout);
        }
    }

    protected class LocalTransactionImpl
    implements LocalTransaction {
        private final boolean isSPI;

        public LocalTransactionImpl(boolean isSPI) {
            this.isSPI = isSPI;
        }

        public void begin() throws ResourceException {
            AbstractManagedConnection.this.localTransactionStart(this.isSPI);
        }

        public void commit() throws ResourceException {
            AbstractManagedConnection.this.localTransactionCommit(this.isSPI);
        }

        public void rollback() throws ResourceException {
            AbstractManagedConnection.this.localTransactionRollback(this.isSPI);
        }
    }
}

