/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiConfigEnforcement;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApiConfigPolicy {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="configEnforcements")
    private List<ApiConfigEnforcement> configEnforcements = null;

    public ApiConfigPolicy name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The policy name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiConfigPolicy version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="The policy version. Useful to differentiate different versions of the same policy. Optional")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ApiConfigPolicy description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A human readable version of what this policy does. Optional")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiConfigPolicy configEnforcements(List<ApiConfigEnforcement> configEnforcements) {
        this.configEnforcements = configEnforcements;
        return this;
    }

    public ApiConfigPolicy addConfigEnforcementsItem(ApiConfigEnforcement configEnforcementsItem) {
        if (this.configEnforcements == null) {
            this.configEnforcements = new ArrayList<ApiConfigEnforcement>();
        }
        this.configEnforcements.add(configEnforcementsItem);
        return this;
    }

    @Schema(description="A list of configuration enforcements.")
    public List<ApiConfigEnforcement> getConfigEnforcements() {
        return this.configEnforcements;
    }

    public void setConfigEnforcements(List<ApiConfigEnforcement> configEnforcements) {
        this.configEnforcements = configEnforcements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiConfigPolicy apiConfigPolicy = (ApiConfigPolicy)o;
        return Objects.equals(this.name, apiConfigPolicy.name) && Objects.equals(this.version, apiConfigPolicy.version) && Objects.equals(this.description, apiConfigPolicy.description) && Objects.equals(this.configEnforcements, apiConfigPolicy.configEnforcements);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.description, this.configEnforcements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiConfigPolicy {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    configEnforcements: ").append(this.toIndentedString(this.configEnforcements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

