/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.NodeVisitor;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.annotations.Provider;

@Experimental
@Immutable
@Provider
public interface Node {
    @Nullable
    public Artifact getArtifact();

    @Nullable
    public Dependency getDependency();

    @Nonnull
    public List<Node> getChildren();

    @Nonnull
    public List<RemoteRepository> getRemoteRepositories();

    @Nonnull
    public Optional<RemoteRepository> getRepository();

    public boolean accept(@Nonnull NodeVisitor var1);

    @Nonnull
    public Node filter(@Nonnull Predicate<Node> var1);

    @Nonnull
    public String asString();

    @Nonnull
    default public Stream<Node> stream() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(Node::stream));
    }
}

