/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.sources;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.MasterSourceMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.codehaus.plexus.components.secdispatcher.internal.sources.PrefixMasterSourceSupport;

@Singleton
@Named(value="gpg-agent")
public final class GpgAgentMasterSource
extends PrefixMasterSourceSupport
implements MasterSourceMeta {
    public static final String NAME = "gpg-agent";

    public GpgAgentMasterSource() {
        super("gpg-agent:");
    }

    @Override
    public String description() {
        return "GPG Agent (agent socket path should be edited)";
    }

    @Override
    public Optional<String> configTemplate() {
        return Optional.of("gpg-agent:$agentSocketPath");
    }

    @Override
    protected String doHandle(String transformed) throws SecDispatcherException {
        String extra = "";
        if (transformed.contains("?")) {
            extra = transformed.substring(transformed.indexOf("?"));
            transformed = transformed.substring(0, transformed.indexOf("?"));
        }
        String socketLocation = transformed;
        boolean interactive = !extra.contains("non-interactive");
        try {
            Path socketLocationPath = Paths.get(socketLocation, new String[0]);
            if (!socketLocationPath.isAbsolute()) {
                socketLocationPath = Paths.get(System.getProperty("user.home"), new String[0]).resolve(socketLocationPath).toAbsolutePath();
            }
            return this.load(socketLocationPath, interactive);
        }
        catch (IOException e) {
            throw new SecDispatcherException(e.getMessage(), e);
        }
    }

    @Override
    protected SecDispatcher.ValidationResponse doValidateConfiguration(String transformed) {
        boolean interactive;
        Path socketLocation;
        HashMap<SecDispatcher.ValidationResponse.Level, List<String>> report = new HashMap<SecDispatcher.ValidationResponse.Level, List<String>>();
        boolean valid = false;
        String extra = "";
        if (transformed.contains("?")) {
            extra = transformed.substring(transformed.indexOf("?"));
            transformed = transformed.substring(0, transformed.indexOf("?"));
        }
        if (!(socketLocation = Paths.get(transformed, new String[0])).isAbsolute()) {
            socketLocation = Paths.get(System.getProperty("user.home"), new String[0]).resolve(socketLocation).toAbsolutePath();
        }
        if (Files.exists(socketLocation, new LinkOption[0])) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.ERROR, k -> new ArrayList()).add("Unix domain socket for GPG Agent does not exist. Maybe you need to start gpg-agent?");
        } else {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.INFO, k -> new ArrayList()).add("Unix domain socket for GPG Agent exist");
            valid = true;
        }
        boolean bl = interactive = !extra.contains("non-interactive");
        if (!interactive) {
            report.computeIfAbsent(SecDispatcher.ValidationResponse.Level.WARNING, k -> new ArrayList()).add("Non-interactive flag found, gpg-agent will not ask for passphrase, it can use only cached ones");
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), valid, report, List.of());
    }

    /*
     * Exception decompiling
     */
    private String load(Path socketPath, boolean interactive) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void expectOK(BufferedReader in) throws IOException {
        String response = in.readLine();
        if (!response.startsWith("OK")) {
            throw new IOException("Expected OK but got this instead: " + response);
        }
    }

    private String mayExpectOK(BufferedReader in) throws IOException {
        String response = in.readLine();
        if (response.startsWith("ERR")) {
            return null;
        }
        if (!response.startsWith("OK")) {
            throw new IOException("Expected OK/ERR but got this instead: " + response);
        }
        return new String(HexFormat.of().parseHex(response.substring(Math.min(response.length(), 3)).trim()));
    }
}

