/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.model;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.model.DataModel;
import javax.faces.model.FacesDataModel;
import org.apache.myfaces.cdi.model.DataModelInfo;
import org.apache.myfaces.cdi.model.DynamicDataModelProducer;
import org.apache.myfaces.cdi.model.FacesDataModelClassBeanHolder;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.shared.util.ClassUtils;

public class FacesDataModelExtension
implements Extension {
    private Set<DataModelInfo> types = new HashSet<DataModelInfo>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType beanHolder = beanManager.createAnnotatedType(FacesDataModelClassBeanHolder.class);
        event.addAnnotatedType(beanHolder, beanHolder.getJavaClass().getName());
    }

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesDataModel.class)) {
            boolean hasValue;
            AnnotatedType annotated = event.getAnnotatedBeanClass();
            Type type = annotated.getBaseType();
            FacesDataModel conv = (FacesDataModel)annotated.getAnnotation(FacesDataModel.class);
            boolean bl = hasValue = conv.forClass() != null;
            if (hasValue) {
                this.types.add(new DataModelInfo(type, conv.forClass()));
            }
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (DataModelInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new DynamicDataModelProducer(beanManager, typeInfo));
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        FacesDataModelClassBeanHolder holder = CDIUtils.lookup(beanManager, FacesDataModelClassBeanHolder.class);
        for (DataModelInfo typeInfo : this.types) {
            holder.addFacesDataModel(typeInfo.getForClass(), ClassUtils.simpleClassForName(typeInfo.getType().getTypeName()));
        }
        Map<Class<?>, Class<? extends DataModel>> map = holder.getClassInstanceToDataModelWrapperClassMap();
    }
}

