/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.SourceGroupRelativeModifierImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class SourcesHelper {
    private static final Logger LOG = Logger.getLogger(SourcesHelper.class.getName());
    private final AntProjectHelper aph;
    private final Project project;
    private final PropertyEvaluator evaluator;
    private final List<SourceRoot> principalSourceRoots = new ArrayList<SourceRoot>();
    private final List<Root> nonSourceRoots = new ArrayList<Root>();
    private final List<Root> ownedFiles = new ArrayList<Root>();
    private final List<TypedSourceRoot> typedSourceRoots = new ArrayList<TypedSourceRoot>();
    private int registeredRootAlgorithm;
    private boolean minimalSubfolders;
    private Set<FileObject> lastRegisteredRoots;
    private PropertyChangeListener propChangeL;
    private Set<SourcesImpl> knownSources = Collections.newSetFromMap(new WeakHashMap());

    @Deprecated
    public SourcesHelper(AntProjectHelper aph, PropertyEvaluator evaluator) {
        this.project = null;
        this.aph = aph;
        this.evaluator = evaluator;
    }

    public SourcesHelper(Project project, AntProjectHelper aph, PropertyEvaluator evaluator) {
        Parameters.notNull("project", project);
        this.project = project;
        this.aph = aph;
        this.evaluator = evaluator;
    }

    public SourceRootConfig sourceRoot(String location) {
        return new SourceRootConfig(location);
    }

    @Deprecated
    public void addPrincipalSourceRoot(String location, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        this.addPrincipalSourceRoot(location, null, null, displayName, icon, openedIcon);
    }

    @Deprecated
    public void addPrincipalSourceRoot(String location, String includes, String excludes, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        SourceRootConfig cfg = this.sourceRoot(location).displayName(displayName).icon(icon).openedIcon(openedIcon);
        if (includes != null) {
            cfg.includes(includes);
        }
        if (excludes != null) {
            cfg.excludes(excludes);
        }
        cfg.add();
    }

    public void addNonSourceRoot(String location) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.nonSourceRoots.add(new Root(location));
    }

    public void addOwnedFile(String location) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.ownedFiles.add(new Root(location));
    }

    @Deprecated
    public void addTypedSourceRoot(String location, String type, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        this.addTypedSourceRoot(location, null, null, type, displayName, icon, openedIcon);
    }

    @Deprecated
    public void addTypedSourceRoot(String location, String includes, String excludes, String type, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        SourceRootConfig cfg = this.sourceRoot(location).type(type).displayName(displayName).icon(icon).openedIcon(openedIcon);
        if (includes != null) {
            cfg.includes(includes);
        }
        if (excludes != null) {
            cfg.excludes(excludes);
        }
        cfg.add();
    }

    private Project getProject() {
        return this.project != null ? this.project : AntBasedProjectFactorySingleton.getProjectFor(this.aph);
    }

    public void registerExternalRoots(int algorithm) throws IllegalArgumentException, IllegalStateException {
        this.registerExternalRoots(algorithm, true);
    }

    public void registerExternalRoots(int algorithm, boolean minimalSubfolders) throws IllegalArgumentException, IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called before");
        }
        this.registeredRootAlgorithm = algorithm;
        this.minimalSubfolders = minimalSubfolders;
        this.remarkExternalRoots();
    }

    private void remarkExternalRoots() throws IllegalArgumentException {
        ArrayList<SourceRoot> allRoots = new ArrayList<SourceRoot>(this.principalSourceRoots);
        allRoots.addAll(this.nonSourceRoots);
        allRoots.addAll(this.ownedFiles);
        Project p = this.getProject();
        FileObject pdir = this.aph.getProjectDirectory();
        if (this.lastRegisteredRoots == null) {
            this.lastRegisteredRoots = Collections.emptySet();
            this.propChangeL = new PropChangeL();
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange(this.propChangeL, this.evaluator));
        }
        HashSet<FileObject> newRegisteredRoots = new HashSet<FileObject>();
        for (Root root : allRoots) {
            for (FileObject loc : root.getIncludeRoots(this.minimalSubfolders)) {
                if (FileUtil.getRelativePath(pdir, loc) != null) continue;
                if (loc.isFolder()) {
                    try {
                        Project other = ProjectManager.getDefault().findProject(loc);
                        if (other != null && !ProjectConvertors.isConvertorProject(other)) {
                        }
                    }
                    catch (IOException e) {}
                    continue;
                }
                newRegisteredRoots.add(loc);
            }
        }
        HashSet<FileObject> toUnregister = new HashSet<FileObject>(this.lastRegisteredRoots);
        toUnregister.removeAll(newRegisteredRoots);
        for (FileObject loc : toUnregister) {
            FileOwnerQuery.markExternalOwner(loc, null, this.registeredRootAlgorithm);
        }
        HashSet hashSet = new HashSet(newRegisteredRoots);
        hashSet.removeAll(this.lastRegisteredRoots);
        for (FileObject loc : hashSet) {
            FileOwnerQuery.markExternalOwner(loc, p, this.registeredRootAlgorithm);
        }
        this.lastRegisteredRoots = newRegisteredRoots;
    }

    public Sources createSources() {
        SourcesImpl si = new SourcesImpl();
        this.knownSources.add(si);
        return si;
    }

    public SourceGroupModifierImplementation createSourceGroupModifierImplementation() {
        return new SourceGroupModifierImpl();
    }

    public final class SourceRootConfig {
        private String location;
        private String displayName;
        private Icon icon;
        private Icon openedIcon;
        private String includes;
        private String excludes;
        private String type;
        private String hint;
        private String[] parts;

        private SourceRootConfig(String location) {
            this.location = location;
        }

        public SourceRootConfig displayName(String value) {
            this.displayName = value;
            return this;
        }

        public SourceRootConfig includes(String value) throws IllegalArgumentException {
            if (value == null) {
                throw new IllegalArgumentException("Parameter 'value' must not be null.");
            }
            this.includes = value;
            return this;
        }

        public SourceRootConfig excludes(String value) throws IllegalArgumentException {
            if (value == null) {
                throw new IllegalArgumentException("Parameter 'value' must not be null.");
            }
            this.excludes = value;
            return this;
        }

        public SourceRootConfig type(String value) {
            this.type = value;
            return this;
        }

        public SourceRootConfig hint(String value) {
            this.hint = value;
            return this;
        }

        public SourceRootConfig icon(Icon value) {
            this.icon = value;
            return this;
        }

        public SourceRootConfig openedIcon(Icon value) {
            this.openedIcon = value;
            return this;
        }

        public SourceRootConfig inParts(String ... parts) {
            this.parts = parts;
            return this;
        }

        public SourceRootConfig add() throws IllegalStateException {
            if (SourcesHelper.this.lastRegisteredRoots != null) {
                throw new IllegalStateException("registerExternalRoots was already called");
            }
            if (this.type != null) {
                SourcesHelper.this.typedSourceRoots.add(new TypedSourceRoot(this.type, this.hint, this.location, this.includes, this.excludes, this.displayName, this.icon, this.openedIcon, this.parts));
            } else {
                SourcesHelper.this.principalSourceRoots.add(new SourceRoot(this.location, this.includes, this.excludes, this.hint, this.displayName, this.icon, this.openedIcon, this.parts));
            }
            return this;
        }
    }

    private class Root {
        protected final String location;

        public Root(String location) {
            this.location = location;
        }

        public final File getActualLocation() {
            String val = SourcesHelper.this.evaluator.evaluate(this.location);
            if (val == null) {
                return null;
            }
            return SourcesHelper.this.aph.resolveFile(val);
        }

        public Collection<FileObject> getIncludeRoots(boolean minimalSubfolders) {
            FileObject fo;
            File loc = this.getActualLocation();
            if (loc != null && (fo = FileUtil.toFileObject(loc)) != null) {
                return Collections.singleton(fo);
            }
            return Collections.emptySet();
        }

        public String toString() {
            return "Root[" + this.location + "]";
        }
    }

    private final class PropChangeL
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            for (SourceRoot r : SourcesHelper.this.principalSourceRoots) {
                r.resetIncludeExcludePatterns();
            }
            SourcesHelper.this.remarkExternalRoots();
        }
    }

    private final class SourcesImpl
    implements Sources,
    PropertyChangeListener,
    FileChangeListener {
        private final ChangeSupport cs = new ChangeSupport(this);
        private boolean haveAttachedListeners;
        private final Set<File> rootsListenedTo = new HashSet<File>();
        private final Map<String, List<URL>> lastComputedRoots = new HashMap<String, List<URL>>();

        public SourcesImpl() {
            SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange(this, SourcesHelper.this.evaluator));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SourceGroup[] getSourceGroups(String type) {
            ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
            if (type.equals("generic")) {
                ArrayList<SourceRoot> roots = new ArrayList<SourceRoot>(SourcesHelper.this.principalSourceRoots);
                roots.add(new SourceRoot("", null, null, null, ProjectUtils.getInformation(SourcesHelper.this.getProject()).getDisplayName(), null, null, null));
                LinkedHashMap<FileObject, SourceRoot> rootsByDir = new LinkedHashMap<FileObject, SourceRoot>();
                for (SourceRoot r : roots) {
                    File file = r.getActualLocation();
                    if (file == null) continue;
                    this.listen(file);
                    FileObject loc = FileUtil.toFileObject(file);
                    if (loc == null) continue;
                    if (!loc.isFolder()) {
                        LOG.log(Level.WARNING, "Group root: {0} is not a folder.", FileUtil.getFileDisplayName(loc));
                        continue;
                    }
                    if (rootsByDir.containsKey(loc)) continue;
                    rootsByDir.put(loc, r);
                }
                Iterator it = rootsByDir.keySet().iterator();
                block1: while (it.hasNext()) {
                    void var7_10;
                    FileObject loc = (FileObject)it.next();
                    FileObject fileObject = loc.getParent();
                    while (var7_10 != null) {
                        if (rootsByDir.containsKey(var7_10)) {
                            ((SourceRoot)rootsByDir.get((Object)loc)).removed = true;
                            it.remove();
                            continue block1;
                        }
                        FileObject fileObject2 = var7_10.getParent();
                    }
                }
                for (Map.Entry entry : rootsByDir.entrySet()) {
                    groups.add(((SourceRoot)entry.getValue()).toGroup((FileObject)entry.getKey()));
                }
            } else {
                HashSet<FileObject> dirs = new HashSet<FileObject>();
                LOG.log(Level.FINE, "Calculating groups of type: {0} for: {1}", new Object[]{type, FileUtil.getFileDisplayName(SourcesHelper.this.aph.getProjectDirectory())});
                for (TypedSourceRoot r : SourcesHelper.this.typedSourceRoots) {
                    if (!r.getType().equals(type)) continue;
                    File locF = r.getActualLocation();
                    if (locF == null) {
                        LOG.log(Level.FINE, "Cannot resolve file for: {0}", r.location);
                        continue;
                    }
                    this.listen(locF);
                    FileObject fileObject = FileUtil.toFileObject(locF);
                    if (fileObject == null) {
                        LOG.log(Level.FINE, "Cannot resolve FileObject for: {0}", locF);
                        continue;
                    }
                    if (!fileObject.isFolder()) {
                        LOG.log(Level.WARNING, "Group root: {0} is not a folder.", FileUtil.getFileDisplayName(fileObject));
                        continue;
                    }
                    if (!dirs.add(fileObject)) continue;
                    SourceGroup sg = r.toGroup(fileObject);
                    groups.add(sg);
                    LOG.log(Level.FINE, "Added group: {0}", sg);
                }
            }
            ArrayList<URL> rootURLs = new ArrayList<URL>(groups.size());
            for (SourceGroup g : groups) {
                rootURLs.add(g.getRootFolder().toURL());
            }
            this.lastComputedRoots.put(type, rootURLs);
            return groups.toArray(new SourceGroup[0]);
        }

        private synchronized void listen(File rootLocation) {
            if (this.rootsListenedTo.add(rootLocation) && this.haveAttachedListeners) {
                FileUtil.addFileChangeListener(this, rootLocation);
            }
        }

        @Override
        public synchronized void addChangeListener(ChangeListener listener) {
            if (!this.haveAttachedListeners) {
                this.haveAttachedListeners = true;
                for (File rootLocation : this.rootsListenedTo) {
                    FileUtil.addFileChangeListener(this, rootLocation);
                }
            }
            this.cs.addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        private void maybeFireChange() {
            boolean change = false;
            for (String type : new HashSet<String>(this.lastComputedRoots.keySet())) {
                ArrayList previous = new ArrayList(this.lastComputedRoots.get(type));
                this.getSourceGroups(type);
                List<URL> nue = this.lastComputedRoots.get(type);
                if (nue.equals(previous)) continue;
                change = true;
                break;
            }
            if (change) {
                this.cs.fireChange();
            }
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
            this.maybeFireChange();
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            this.maybeFireChange();
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.maybeFireChange();
        }

        @Override
        public void fileChanged(FileEvent fe) {
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.maybeFireChange();
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.maybeFireChange();
        }
    }

    private class SourceGroupModifierImpl
    implements SourceGroupModifierImplementation,
    SourceGroupRelativeModifierImplementation {
        private final Function<SourceRoot, Integer> similarity;

        public SourceGroupModifierImpl() {
            this(null);
        }

        public SourceGroupModifierImpl(Function<SourceRoot, Integer> similarity) {
            this.similarity = similarity;
        }

        @Override
        public SourceGroup createSourceGroup(String type, String hint) {
            FileObject foloc;
            SourceRoot root = this.findRoot(type, hint, this.similarity);
            if (root == null) {
                return null;
            }
            if (root.isRemoved()) {
                return null;
            }
            File loc = root.getActualLocation();
            if (!loc.exists()) {
                try {
                    foloc = FileUtil.createFolder(loc);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to create folder " + loc, ex);
                    return null;
                }
            } else {
                foloc = FileUtil.toFileObject(loc);
            }
            SourceGroup sg = root.toGroup(foloc);
            assert (sg != null);
            for (SourcesImpl sourcesImpl : SourcesHelper.this.knownSources) {
                sourcesImpl.maybeFireChange();
            }
            return sg;
        }

        @Override
        public boolean canCreateSourceGroup(String type, String hint) {
            return this.findRoot(type, hint, this.similarity) != null;
        }

        private SourceRoot findRoot(String type, String hint, Function<SourceRoot, Integer> similarity) {
            int maxSimilarity = -1;
            SourceRoot candidate = null;
            if ("generic".equals(type)) {
                for (SourceRoot root : SourcesHelper.this.principalSourceRoots) {
                    if (root.getHint() == null || !root.getHint().equals(hint) || root.isRemoved()) continue;
                    if (similarity == null) {
                        return root;
                    }
                    int sim = similarity.apply(root);
                    if (sim <= maxSimilarity) continue;
                    candidate = root;
                    maxSimilarity = sim;
                }
            } else {
                for (TypedSourceRoot root : SourcesHelper.this.typedSourceRoots) {
                    if (root.getHint() == null || !root.getType().equals(type) || !root.getHint().equals(hint)) continue;
                    if (similarity == null) {
                        return root;
                    }
                    int sim = similarity.apply(root);
                    if (sim <= maxSimilarity) continue;
                    candidate = root;
                    maxSimilarity = sim;
                }
            }
            return candidate;
        }

        @Override
        public SourceGroupModifierImplementation relativeTo(SourceGroup existingGroup, String ... projectPart) {
            SourceRoot origin = null;
            if (existingGroup != null) {
                FileObject fo = existingGroup.getRootFolder();
                File f = FileUtil.toFile(fo);
                for (SourceRoot r : SourcesHelper.this.principalSourceRoots) {
                    File loc = r.getActualLocation();
                    if (loc == null || !loc.equals(f)) continue;
                    origin = r;
                    break;
                }
            }
            return new SourceGroupModifierImpl(new Key(origin, projectPart));
        }
    }

    private static final class Key
    implements Function<SourceRoot, Integer> {
        private SourceRoot root;
        private String[] parts;

        public Key(SourceRoot root, String[] parts) {
            this.root = root;
            this.parts = parts;
        }

        @Override
        public Integer apply(SourceRoot r) {
            int i;
            int result = 0;
            int start = 0;
            if (this.root != null && this.root.projectParts != null && r.projectParts != null) {
                for (i = 0; i < this.root.projectParts.length && i < r.projectParts.length && this.root.projectParts[i].equals(r.projectParts[i]); ++i) {
                    ++start;
                }
            }
            if (this.parts != null && r.projectParts != null) {
                for (i = start; i < this.parts.length && i < r.projectParts.length && this.parts[i].equals(r.projectParts[i]); ++i) {
                    ++result;
                }
            }
            return result + start;
        }
    }

    private final class TypedSourceRoot
    extends SourceRoot {
        private final String type;

        public TypedSourceRoot(String type, String hint, String location, String includes, String excludes, String displayName, Icon icon, Icon openedIcon, String[] parts) {
            super(location, includes, excludes, hint, displayName, icon, openedIcon, parts);
            this.type = type;
        }

        public final String getType() {
            return this.type;
        }
    }

    private class SourceRoot
    extends Root {
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        private final String includes;
        private final String excludes;
        private final String hint;
        private boolean removed;
        private final String[] projectParts;
        private PathMatcher matcher;

        public SourceRoot(String location, String includes, String excludes, String hint, String displayName, Icon icon, Icon openedIcon, String[] parts) {
            super(location);
            this.displayName = displayName;
            this.icon = icon;
            this.openedIcon = openedIcon;
            this.includes = includes;
            this.excludes = excludes;
            this.hint = hint;
            this.projectParts = parts;
            this.removed = false;
        }

        public final SourceGroup toGroup(FileObject loc) {
            assert (loc != null);
            return new Group(loc);
        }

        public String getHint() {
            return this.hint;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        @Override
        public String toString() {
            return "SourceRoot[" + this.location + "]";
        }

        private String evalForMatcher(String raw) {
            if (raw == null) {
                return null;
            }
            String patterns = SourcesHelper.this.evaluator.evaluate(raw);
            if (patterns == null) {
                return null;
            }
            if (patterns.matches("\\$\\{[^}]+\\}")) {
                return null;
            }
            return patterns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PathMatcher computeIncludeExcludePatterns() {
            SourceRoot sourceRoot = this;
            synchronized (sourceRoot) {
                if (this.matcher != null) {
                    return this.matcher;
                }
            }
            String includesPattern = this.evalForMatcher(this.includes);
            String excludesPattern = this.evalForMatcher(this.excludes);
            PathMatcher _matcher = new PathMatcher(includesPattern, excludesPattern, this.getActualLocation());
            SourceRoot sourceRoot2 = this;
            synchronized (sourceRoot2) {
                this.matcher = _matcher;
            }
            return _matcher;
        }

        private synchronized void resetIncludeExcludePatterns() {
            this.matcher = null;
        }

        @Override
        public Collection<FileObject> getIncludeRoots(boolean minimalSubfolders) {
            Collection<FileObject> supe = super.getIncludeRoots(minimalSubfolders);
            if (!minimalSubfolders) {
                return supe;
            }
            if (supe.size() == 1) {
                HashSet<FileObject> roots = new HashSet<FileObject>();
                for (File r : this.computeIncludeExcludePatterns().findIncludedRoots()) {
                    FileObject subroot = FileUtil.toFileObject(r);
                    if (subroot == null) continue;
                    roots.add(subroot);
                }
                return roots;
            }
            assert (supe.isEmpty());
            return supe;
        }

        private final class Group
        implements SourceGroup,
        PropertyChangeListener {
            private final FileObject loc;
            private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

            Group(FileObject loc) {
                this.loc = loc;
                SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange(this, SourcesHelper.this.evaluator));
            }

            @Override
            public FileObject getRootFolder() {
                return this.loc;
            }

            @Override
            public String getName() {
                return SourceRoot.this.location.length() > 0 ? SourceRoot.this.location : "generic";
            }

            @Override
            public String getDisplayName() {
                return SourceRoot.this.displayName;
            }

            @Override
            public Icon getIcon(boolean opened) {
                return opened ? SourceRoot.this.icon : SourceRoot.this.openedIcon;
            }

            @Override
            public boolean contains(FileObject file) {
                if (file == this.loc) {
                    return true;
                }
                Object path = FileUtil.getRelativePath(this.loc, file);
                if (path == null) {
                    return false;
                }
                if (file.isFolder()) {
                    path = (String)path + "/";
                }
                if (!SourceRoot.this.computeIncludeExcludePatterns().matches((String)path, true)) {
                    return false;
                }
                Project p = SourcesHelper.this.getProject();
                if (file.isFolder() && file != p.getProjectDirectory() && ProjectManager.getDefault().isProject(file) && !ProjectConvertors.isConvertorProject(FileOwnerQuery.getOwner(file))) {
                    return false;
                }
                if (!(SourceRoot.this instanceof TypedSourceRoot)) {
                    Project owner = FileOwnerQuery.getOwner(file);
                    if (owner != null && owner != p && !ProjectConvertors.isConvertorProject(owner)) {
                        return false;
                    }
                    if (SharabilityQuery.getSharability(file) == SharabilityQuery.Sharability.NOT_SHARABLE) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
                this.pcs.addPropertyChangeListener(l);
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
                this.pcs.removePropertyChangeListener(l);
            }

            public String toString() {
                return "SourcesHelper.Group[name=" + this.getName() + ",rootFolder=" + this.getRootFolder() + "]";
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                assert (ev.getSource() == SourcesHelper.this.evaluator) : ev;
                String prop = ev.getPropertyName();
                if (prop == null || SourceRoot.this.includes != null && SourceRoot.this.includes.contains("${" + prop + "}") || SourceRoot.this.excludes != null && SourceRoot.this.excludes.contains("${" + prop + "}")) {
                    SourceRoot.this.resetIncludeExcludePatterns();
                    this.pcs.firePropertyChange("containership", null, null);
                }
            }
        }
    }
}

