/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeParams;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;

@SdkInternalApi
public final class FallbackS3AuthSchemeProvider
implements S3AuthSchemeProvider {
    private static final FallbackS3AuthSchemeProvider DEFAULT = new FallbackS3AuthSchemeProvider();

    private FallbackS3AuthSchemeProvider() {
    }

    public static FallbackS3AuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(S3AuthSchemeParams params) {
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        switch (params.operation()) {
            case "UploadPart": 
            case "PutObject": {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"s3").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).putSignerProperty(AwsV4HttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)false).putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)false).putSignerProperty(AwsV4HttpSigner.NORMALIZE_PATH, (Object)false).putSignerProperty(AwsV4HttpSigner.CHUNK_ENCODING_ENABLED, (Object)true).build());
                break;
            }
            default: {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"s3").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).putSignerProperty(AwsV4HttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)false).putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)false).putSignerProperty(AwsV4HttpSigner.NORMALIZE_PATH, (Object)false).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

