/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.lang.model.types;

import jakarta.enterprise.lang.model.AnnotationTarget;
import jakarta.enterprise.lang.model.declarations.DeclarationInfo;
import jakarta.enterprise.lang.model.types.ArrayType;
import jakarta.enterprise.lang.model.types.ClassType;
import jakarta.enterprise.lang.model.types.ParameterizedType;
import jakarta.enterprise.lang.model.types.PrimitiveType;
import jakarta.enterprise.lang.model.types.TypeVariable;
import jakarta.enterprise.lang.model.types.VoidType;
import jakarta.enterprise.lang.model.types.WildcardType;

public interface Type
extends AnnotationTarget {
    @Override
    default public boolean isDeclaration() {
        return false;
    }

    @Override
    default public boolean isType() {
        return true;
    }

    @Override
    default public DeclarationInfo asDeclaration() {
        throw new IllegalStateException("Not a declaration");
    }

    @Override
    default public Type asType() {
        return this;
    }

    public Kind kind();

    default public boolean isVoid() {
        return this.kind() == Kind.VOID;
    }

    default public boolean isPrimitive() {
        return this.kind() == Kind.PRIMITIVE;
    }

    default public boolean isClass() {
        return this.kind() == Kind.CLASS;
    }

    default public boolean isArray() {
        return this.kind() == Kind.ARRAY;
    }

    default public boolean isParameterizedType() {
        return this.kind() == Kind.PARAMETERIZED_TYPE;
    }

    default public boolean isTypeVariable() {
        return this.kind() == Kind.TYPE_VARIABLE;
    }

    default public boolean isWildcardType() {
        return this.kind() == Kind.WILDCARD_TYPE;
    }

    default public VoidType asVoid() {
        throw new IllegalStateException("Not a void");
    }

    default public PrimitiveType asPrimitive() {
        throw new IllegalStateException("Not a primitive");
    }

    default public ClassType asClass() {
        throw new IllegalStateException("Not a class");
    }

    default public ArrayType asArray() {
        throw new IllegalStateException("Not an array");
    }

    default public ParameterizedType asParameterizedType() {
        throw new IllegalStateException("Not a parameterized type");
    }

    default public TypeVariable asTypeVariable() {
        throw new IllegalStateException("Not a type variable");
    }

    default public WildcardType asWildcardType() {
        throw new IllegalStateException("Not a wildcard type");
    }

    public static enum Kind {
        VOID,
        PRIMITIVE,
        CLASS,
        ARRAY,
        PARAMETERIZED_TYPE,
        TYPE_VARIABLE,
        WILDCARD_TYPE;

    }
}

