/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.file.monitor;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.util.file.monitor.UpdateMonitor;

public class SynchronousFileWatcher {
    private final Path path;
    private final long checkUpdateMillis;
    private final UpdateMonitor monitor;
    private final AtomicReference<StateWrapper> lastState;
    private final Lock resourceLock = new ReentrantLock();

    public SynchronousFileWatcher(Path path, UpdateMonitor monitor) {
        this(path, monitor, 0L);
    }

    public SynchronousFileWatcher(Path path, UpdateMonitor monitor, long checkMillis) {
        Object currentState;
        if (checkMillis < 0L) {
            throw new IllegalArgumentException();
        }
        this.path = path;
        this.checkUpdateMillis = checkMillis;
        this.monitor = monitor;
        try {
            currentState = monitor.getCurrentState(path);
        }
        catch (IOException e) {
            currentState = null;
        }
        this.lastState = new AtomicReference<StateWrapper>(new StateWrapper(currentState));
    }

    public boolean checkAndReset() throws IOException {
        if (this.checkUpdateMillis <= 0L) {
            return this.checkForUpdate();
        }
        StateWrapper stateWrapper = this.lastState.get();
        if (stateWrapper.getTimestamp() < System.currentTimeMillis() - this.checkUpdateMillis) {
            return this.checkForUpdate();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForUpdate() throws IOException {
        if (this.resourceLock.tryLock()) {
            try {
                Object oldState = this.lastState.get().getState();
                Object newState = this.monitor.getCurrentState(this.path);
                if (newState == null && oldState == null) {
                    boolean bl = false;
                    return bl;
                }
                this.lastState.set(new StateWrapper(newState));
                if (newState == null || oldState == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = !newState.equals(oldState);
                return bl;
            }
            finally {
                this.resourceLock.unlock();
            }
        }
        return false;
    }

    private static class StateWrapper {
        private final Object state;
        private final long timestamp;

        public StateWrapper(Object state) {
            this.state = state;
            this.timestamp = System.currentTimeMillis();
        }

        public Object getState() {
            return this.state;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

