/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.process;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.apache.nifi.bootstrap.command.process.ManagementServerAddressProvider;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;

public class StandardManagementServerAddressProvider
implements ManagementServerAddressProvider {
    private static final int STANDARD_PORT = 52020;
    private static final int MAXIMUM_PORT = 52050;
    private static final String NOT_AVAILABLE_MESSAGE = "Management Server Port not available in range [%d-%d]".formatted(52020, 52050);
    private static final String LOCALHOST_ADDRESS = "127.0.0.1:%d";
    private static final String HOST_ADDRESS = "%s:%d";
    private final ConfigurationProvider configurationProvider;

    public StandardManagementServerAddressProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = Objects.requireNonNull(configurationProvider);
    }

    @Override
    public Optional<String> getAddress() {
        Optional<String> address;
        Optional<URI> managementServerAddress = this.configurationProvider.getManagementServerAddress();
        if (managementServerAddress.isPresent()) {
            URI serverAddress = managementServerAddress.get();
            String hostAddress = HOST_ADDRESS.formatted(serverAddress.getHost(), serverAddress.getPort());
            address = Optional.of(hostAddress);
        } else {
            int serverPort = this.getServerPort();
            address = Optional.of(LOCALHOST_ADDRESS.formatted(serverPort));
        }
        return address;
    }

    private int getServerPort() {
        OptionalInt portFound = IntStream.range(52020, 52050).filter(StandardManagementServerAddressProvider::isPortFree).findFirst();
        return portFound.orElseThrow(() -> new IllegalStateException(NOT_AVAILABLE_MESSAGE));
    }

    private static boolean isPortFree(int port) {
        boolean bl;
        ServerSocket ignored = new ServerSocket(port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }
}

