/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.onenote.ExtendedGUID;
import org.apache.tika.parser.microsoft.onenote.FileNodePtr;
import org.apache.tika.parser.microsoft.onenote.OneNoteDirectFileResource;
import org.apache.tika.parser.microsoft.onenote.OneNoteDocument;
import org.apache.tika.parser.microsoft.onenote.OneNoteHeader;
import org.apache.tika.parser.microsoft.onenote.OneNoteLegacyDumpStrings;
import org.apache.tika.parser.microsoft.onenote.OneNotePtr;
import org.apache.tika.parser.microsoft.onenote.OneNoteTreeWalker;
import org.apache.tika.parser.microsoft.onenote.OneNoteTreeWalkerOptions;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.MSOneStorePackage;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.MSOneStoreParser;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.AlternativePackaging;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.io.IOUtils;

public class OneNoteParser
extends AbstractParser {
    public static final String ONE_NOTE_PREFIX = "onenote:";
    private static final Map<MediaType, List<String>> TYPES_MAP = new HashMap<MediaType, List<String>>();
    private static final long serialVersionUID = -5504243905998074168L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(TYPES_MAP.keySet());
    private final OneNoteTreeWalkerOptions options = new OneNoteTreeWalkerOptions();

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        byte[] oneStoreFileBytes = IOUtils.toByteArray(stream);
        try (TemporaryResources temporaryResources = new TemporaryResources();
             TikaInputStream tikaInputStream = TikaInputStream.get((byte[])oneStoreFileBytes);
             OneNoteDirectFileResource oneNoteDirectFileResource = new OneNoteDirectFileResource(tikaInputStream.getFile());){
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            temporaryResources.addResource((Closeable)oneNoteDirectFileResource);
            OneNoteDocument oneNoteDocument = this.createOneNoteDocumentFromDirectFileResource(oneNoteDirectFileResource);
            OneNoteHeader header = oneNoteDocument.header;
            if (header.isMsOneStoreFormat()) {
                metadata.set("onenote:buildNumberCreated", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberCreated));
                metadata.set("onenote:buildNumberLastWroteToFile", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberLastWroteToFile));
                metadata.set("onenote:buildNumberNewestWritten", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberNewestWritten));
                metadata.set("onenote:buildNumberOldestWritten", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberOldestWritten));
                metadata.set("onenote:cbExpectedFileLength", "0x" + Long.toHexString(oneNoteDocument.header.cbExpectedFileLength));
                metadata.set("onenote:cbFreeSpaceInFreeChunkList", "0x" + Long.toHexString(oneNoteDocument.header.cbFreeSpaceInFreeChunkList));
                metadata.set("onenote:cbLegacyExpectedFileLength", "0x" + Long.toHexString(oneNoteDocument.header.cbLegacyExpectedFileLength));
                metadata.set("onenote:cbLegacyFreeSpaceInFreeChunkList", "0x" + Long.toHexString(oneNoteDocument.header.cbLegacyFreeSpaceInFreeChunkList));
                metadata.set("onenote:crcName", "0x" + Long.toHexString(oneNoteDocument.header.crcName));
                metadata.set("onenote:cTransactionsInLog", "0x" + Long.toHexString(oneNoteDocument.header.cTransactionsInLog));
                metadata.set("onenote:ffvLastCodeThatWroteToThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvLastCodeThatWroteToThisFile));
                metadata.set("onenote:ffvNewestCodeThatHasWrittenToThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvNewestCodeThatHasWrittenToThisFile));
                metadata.set("onenote:ffvOldestCodeThatMayReadThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvOldestCodeThatMayReadThisFile));
                metadata.set("onenote:ffvOldestCodeThatHasWrittenToThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvOldestCodeThatHasWrittenToThisFile));
                metadata.set("onenote:grfDebugLogFlags", "0x" + Long.toHexString(oneNoteDocument.header.grfDebugLogFlags));
                metadata.set("onenote:nFileVersionGeneration", "0x" + Long.toHexString(oneNoteDocument.header.nFileVersionGeneration));
                metadata.set("onenote:rgbPlaceholder", "0x" + Long.toHexString(oneNoteDocument.header.rgbPlaceholder));
                Pair<Long, ExtendedGUID> roleAndContext = Pair.of(1L, ExtendedGUID.nil());
                OneNoteTreeWalker oneNoteTreeWalker = new OneNoteTreeWalker(this.options, oneNoteDocument, oneNoteDirectFileResource, xhtml, metadata, context, roleAndContext);
                oneNoteTreeWalker.walkTree();
                if (!oneNoteTreeWalker.getAuthors().isEmpty()) {
                    metadata.set(TikaCoreProperties.CREATOR, oneNoteTreeWalker.getAuthors().toArray(new String[0]));
                }
                if (!oneNoteTreeWalker.getMostRecentAuthors().isEmpty()) {
                    metadata.set(Property.externalTextBag((String)"onenote:mostRecentAuthors"), oneNoteTreeWalker.getMostRecentAuthors().toArray(new String[0]));
                }
                if (!oneNoteTreeWalker.getOriginalAuthors().isEmpty()) {
                    metadata.set(Property.externalTextBag((String)"onenote:originalAuthors"), oneNoteTreeWalker.getOriginalAuthors().toArray(new String[0]));
                }
                if (!Instant.MAX.equals(Instant.ofEpochMilli(oneNoteTreeWalker.getCreationTimestamp()))) {
                    metadata.set("onenote:creationTimestamp", String.valueOf(oneNoteTreeWalker.getCreationTimestamp()));
                }
                if (!Instant.MIN.equals(oneNoteTreeWalker.getLastModifiedTimestamp())) {
                    metadata.set("onenote:lastModifiedTimestamp", String.valueOf(oneNoteTreeWalker.getLastModifiedTimestamp().toEpochMilli()));
                }
                if (oneNoteTreeWalker.getLastModified() > Long.MIN_VALUE) {
                    metadata.set(TikaCoreProperties.MODIFIED, String.valueOf(oneNoteTreeWalker.getLastModified()));
                }
            } else if (header.isLegacyOrAlternativePackaging()) {
                try {
                    AlternativePackaging alternatePackageOneStoreFile = new AlternativePackaging();
                    alternatePackageOneStoreFile.doDeserializeFromByteArray(oneStoreFileBytes, 0);
                    MSOneStoreParser onenoteParser = new MSOneStoreParser();
                    MSOneStorePackage pkg = onenoteParser.parse(alternatePackageOneStoreFile.dataElementPackage);
                    pkg.walkTree(this.options, metadata, xhtml);
                }
                catch (Exception e) {
                    OneNoteLegacyDumpStrings dumpStrings = new OneNoteLegacyDumpStrings(oneNoteDirectFileResource, xhtml);
                    dumpStrings.dump();
                }
            } else {
                throw new TikaException("Invalid OneStore document - could not parse headers");
            }
            xhtml.endDocument();
        }
    }

    public OneNoteDocument createOneNoteDocumentFromDirectFileResource(OneNoteDirectFileResource oneNoteDirectFileResource) throws IOException, TikaException {
        OneNoteDocument oneNoteDocument = new OneNoteDocument();
        OneNotePtr oneNotePtr = new OneNotePtr(oneNoteDocument, oneNoteDirectFileResource);
        oneNoteDocument.header = oneNotePtr.deserializeHeader();
        if (oneNoteDocument.header.isMsOneStoreFormat()) {
            oneNotePtr.reposition(oneNoteDocument.header.fcrFileNodeListRoot);
            FileNodePtr curPath = new FileNodePtr();
            oneNotePtr.deserializeFileNodeList(oneNoteDocument.root, curPath);
        }
        return oneNoteDocument;
    }

    static {
        TYPES_MAP.put(MediaType.application((String)"onenote; format=one"), Collections.singletonList("ONE "));
    }
}

