/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.math.BigInteger;
import java.util.Date;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.ParagraphProperties;
import org.apache.tika.parser.microsoft.ooxml.RunProperties;
import org.apache.tika.parser.microsoft.ooxml.XWPFListManager;
import org.apache.tika.parser.microsoft.ooxml.xwpf.XWPFStylesShim;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OOXMLTikaBodyPartHandler
implements OOXMLWordAndPowerPointTextHandler.XWPFBodyContentsHandler {
    private static final String P = "p";
    private static final char[] NEWLINE = new char[]{'\n'};
    private final XHTMLContentHandler xhtml;
    private final XWPFListManager listManager;
    private final boolean includeDeletedText;
    private final boolean includeMoveFromText;
    private final XWPFStylesShim styles;
    private int pDepth = 0;
    private int tableDepth = 0;
    private int sdtDepth = 0;
    private boolean isItalics = false;
    private boolean isBold = false;
    private boolean isUnderline = false;
    private boolean isStrikeThrough = false;
    private boolean wroteHyperlinkStart = false;
    private int tableCellDepth = 0;
    private int pWithinCell = 0;
    private String paragraphTag = null;

    public OOXMLTikaBodyPartHandler(XHTMLContentHandler xhtml) {
        this.xhtml = xhtml;
        this.styles = XWPFStylesShim.EMPTY_STYLES;
        this.listManager = XWPFListManager.EMPTY_LIST;
        this.includeDeletedText = false;
        this.includeMoveFromText = false;
    }

    public OOXMLTikaBodyPartHandler(XHTMLContentHandler xhtml, XWPFStylesShim styles, XWPFListManager listManager, OfficeParserConfig parserConfig) {
        this.xhtml = xhtml;
        this.styles = styles;
        this.listManager = listManager;
        this.includeDeletedText = parserConfig.isIncludeDeletedContent();
        this.includeMoveFromText = parserConfig.isIncludeMoveFromContent();
    }

    @Override
    public void run(RunProperties runProperties, String contents) throws SAXException {
        boolean runIsUnderlined;
        if (runProperties.isBold() != this.isBold) {
            if (this.isStrikeThrough) {
                this.xhtml.endElement("strike");
                this.isStrikeThrough = false;
            }
            if (this.isUnderline) {
                this.xhtml.endElement("u");
                this.isUnderline = false;
            }
            if (this.isItalics) {
                this.xhtml.endElement("i");
                this.isItalics = false;
            }
            if (runProperties.isBold()) {
                this.xhtml.startElement("b");
            } else {
                this.xhtml.endElement("b");
            }
            this.isBold = runProperties.isBold();
        }
        if (runProperties.isItalics() != this.isItalics) {
            if (this.isStrikeThrough) {
                this.xhtml.endElement("strike");
                this.isStrikeThrough = false;
            }
            if (this.isUnderline) {
                this.xhtml.endElement("u");
                this.isUnderline = false;
            }
            if (runProperties.isItalics()) {
                this.xhtml.startElement("i");
            } else {
                this.xhtml.endElement("i");
            }
            this.isItalics = runProperties.isItalics();
        }
        if (runProperties.isStrikeThrough() != this.isStrikeThrough) {
            if (this.isUnderline) {
                this.xhtml.endElement("u");
                this.isUnderline = false;
            }
            if (runProperties.isStrikeThrough()) {
                this.xhtml.startElement("strike");
            } else {
                this.xhtml.endElement("strike");
            }
            this.isStrikeThrough = runProperties.isStrikeThrough();
        }
        boolean bl = runIsUnderlined = runProperties.getUnderline() != UnderlinePatterns.NONE;
        if (runIsUnderlined != this.isUnderline) {
            if (runIsUnderlined) {
                this.xhtml.startElement("u");
            } else {
                this.xhtml.endElement("u");
            }
            this.isUnderline = runIsUnderlined;
        }
        this.xhtml.characters(contents);
    }

    @Override
    public void hyperlinkStart(String link) throws SAXException {
        if (link != null) {
            this.xhtml.startElement("a", "href", link);
            this.wroteHyperlinkStart = true;
        }
    }

    @Override
    public void hyperlinkEnd() throws SAXException {
        if (this.wroteHyperlinkStart) {
            this.closeStyleTags();
            this.wroteHyperlinkStart = false;
            this.xhtml.endElement("a");
        }
    }

    @Override
    public void startParagraph(ParagraphProperties paragraphProperties) throws SAXException {
        if (this.tableCellDepth > 0 && this.pWithinCell > 0) {
            this.xhtml.characters(NEWLINE, 0, 1);
        }
        if (this.pDepth == 0 && this.tableDepth == 0 && this.sdtDepth == 0) {
            String styleName;
            this.paragraphTag = P;
            String styleClass = null;
            if (paragraphProperties.getStyleID() != null && this.styles != null && (styleName = this.styles.getStyleName(paragraphProperties.getStyleID())) != null) {
                WordExtractor.TagAndStyle tas = WordExtractor.buildParagraphTagAndStyle(styleName, false);
                this.paragraphTag = tas.getTag();
                styleClass = tas.getStyleClass();
            }
            if (styleClass == null) {
                this.xhtml.startElement(this.paragraphTag);
            } else {
                this.xhtml.startElement(this.paragraphTag, "class", styleClass);
            }
        }
        this.writeParagraphNumber(paragraphProperties.getNumId(), paragraphProperties.getIlvl(), this.listManager, this.xhtml);
        ++this.pDepth;
    }

    @Override
    public void endParagraph() throws SAXException {
        this.closeStyleTags();
        if (this.pDepth == 1 && this.tableDepth == 0) {
            this.xhtml.endElement(this.paragraphTag);
        } else if (this.tableCellDepth > 0 && this.pWithinCell > 0) {
            this.xhtml.characters(NEWLINE, 0, 1);
        } else if (this.tableCellDepth == 0) {
            this.xhtml.characters(NEWLINE, 0, 1);
        }
        if (this.tableCellDepth > 0) {
            ++this.pWithinCell;
        }
        --this.pDepth;
    }

    @Override
    public void startTable() throws SAXException {
        this.xhtml.startElement("table");
        ++this.tableDepth;
    }

    @Override
    public void endTable() throws SAXException {
        this.xhtml.endElement("table");
        --this.tableDepth;
    }

    @Override
    public void startTableRow() throws SAXException {
        this.xhtml.startElement("tr");
    }

    @Override
    public void endTableRow() throws SAXException {
        this.xhtml.endElement("tr");
    }

    @Override
    public void startTableCell() throws SAXException {
        this.xhtml.startElement("td");
        ++this.tableCellDepth;
    }

    @Override
    public void endTableCell() throws SAXException {
        this.xhtml.endElement("td");
        this.pWithinCell = 0;
        --this.tableCellDepth;
    }

    @Override
    public void startSDT() throws SAXException {
        this.closeStyleTags();
        ++this.sdtDepth;
    }

    @Override
    public void endSDT() {
        --this.sdtDepth;
    }

    @Override
    public void startEditedSection(String editor, Date date, OOXMLWordAndPowerPointTextHandler.EditType editType) {
    }

    @Override
    public void endEditedSection() {
    }

    @Override
    public boolean isIncludeDeletedText() {
        return this.includeDeletedText;
    }

    @Override
    public void footnoteReference(String id) throws SAXException {
        if (id != null) {
            this.xhtml.characters("[");
            this.xhtml.characters(id);
            this.xhtml.characters("]");
        }
    }

    @Override
    public void endnoteReference(String id) throws SAXException {
        if (id != null) {
            this.xhtml.characters("[");
            this.xhtml.characters(id);
            this.xhtml.characters("]");
        }
    }

    @Override
    public boolean isIncludeMoveFromText() {
        return this.includeMoveFromText;
    }

    @Override
    public void embeddedOLERef(String relId) throws SAXException {
        if (relId == null) {
            return;
        }
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "class", "class", "CDATA", "embedded");
        attributes.addAttribute("", "id", "id", "CDATA", relId);
        this.xhtml.startElement("div", attributes);
        this.xhtml.endElement("div");
    }

    @Override
    public void embeddedPicRef(String picFileName, String picDescription) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        if (picFileName != null) {
            attr.addAttribute("", "src", "src", "CDATA", "embedded:" + picFileName);
        }
        if (picDescription != null) {
            attr.addAttribute("", "alt", "alt", "CDATA", picDescription);
        }
        this.xhtml.startElement("img", attr);
        this.xhtml.endElement("img");
    }

    @Override
    public void startBookmark(String id, String name) throws SAXException {
        if (name != null && !this.wroteHyperlinkStart) {
            this.xhtml.startElement("a", "name", name);
            this.xhtml.endElement("a");
        }
    }

    @Override
    public void endBookmark(String id) {
    }

    private void closeStyleTags() throws SAXException {
        if (this.isStrikeThrough) {
            this.xhtml.endElement("strike");
            this.isStrikeThrough = false;
        }
        if (this.isUnderline) {
            this.xhtml.endElement("u");
            this.isUnderline = false;
        }
        if (this.isItalics) {
            this.xhtml.endElement("i");
            this.isItalics = false;
        }
        if (this.isBold) {
            this.xhtml.endElement("b");
            this.isBold = false;
        }
    }

    private void writeParagraphNumber(int numId, int ilvl, XWPFListManager listManager, XHTMLContentHandler xhtml) throws SAXException {
        if (ilvl < 0 || numId < 0 || listManager == null) {
            return;
        }
        String number = listManager.getFormattedNumber(BigInteger.valueOf(numId), ilvl);
        if (number != null) {
            xhtml.characters(number);
        }
    }
}

