/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractOfficeParser;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.Word2006MLDocHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import shaded.org.apache.commons.io.input.CloseShieldInputStream;

public class Word2006MLParser
extends AbstractOfficeParser {
    protected static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"vnd.ms-word2006ml"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.configure(context);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            XMLReaderUtils.getSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new EmbeddedContentHandler((ContentHandler)new Word2006MLDocHandler(xhtml, metadata, context)));
        }
        catch (SAXException e) {
            throw new TikaException("XML parse error", (Throwable)e);
        }
        xhtml.endDocument();
    }
}

