/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.tika.config.Field;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.txt.UniversalEncodingListener;

public class UniversalEncodingDetector
implements EncodingDetector {
    private static final int BUFSIZE = 1024;
    private static final int DEFAULT_MARK_LIMIT = 16384;
    private int markLimit = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return null;
        }
        input.mark(this.markLimit);
        try {
            UniversalEncodingListener listener = new UniversalEncodingListener(metadata);
            byte[] b = new byte[1024];
            int n = 0;
            int m = input.read(b);
            while (m != -1 && n < this.markLimit && !listener.isDone()) {
                listener.handleData(b, 0, m);
                m = input.read(b, 0, Math.min(b.length, this.markLimit - (n += m)));
            }
            Charset charset = listener.dataEnd();
            return charset;
        }
        catch (LinkageError e) {
            Charset charset = null;
            return charset;
        }
        finally {
            input.reset();
        }
    }

    public int getMarkLimit() {
        return this.markLimit;
    }

    @Field
    public void setMarkLimit(int markLimit) {
        this.markLimit = markLimit;
    }
}

