/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.tld;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLDIndexingFilter
implements IndexingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration conf;

    public NutchDocument filter(NutchDocument doc, Parse parse, Text urlText, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        try {
            URL url = new URL(urlText.toString());
            String domain = URLUtil.getDomainSuffix((URL)url);
            doc.add("tld", (Object)domain);
        }
        catch (Exception ex) {
            LOG.warn(ex.toString());
        }
        return doc;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

