/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import com.barchart.udt.OptionUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.net.NetSocketUDT;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AppClient {
    static boolean finished = false;

    public static void main(String[] args) {
        int port = 9000;
        int size = 10000;
        byte[] data = new byte[10000];
        Future<Boolean> monResult = null;
        if (args.length != 2) {
            System.out.println("usage: appclient server_host server_port");
            return;
        }
        String host = args[0];
        port = Integer.parseInt(args[1]);
        try {
            final NetSocketUDT socket = new NetSocketUDT();
            if (System.getProperty("os.name").contains("win")) {
                socket.socketUDT().setOption(OptionUDT.UDT_MSS, 1052);
            }
            socket.connect(new InetSocketAddress(host, port));
            OutputStream os = socket.getOutputStream();
            monResult = Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return AppClient.monitor(socket.socketUDT());
                }
            });
            for (int i = 0; i < 1000000; ++i) {
                os.write(data);
            }
            finished = true;
            if (monResult != null) {
                monResult.get();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static boolean monitor(SocketUDT socket) {
        System.out.println("SendRate(Mb/s)\tRTT(ms)\tCWnd\tPktSndPeriod(us)\tRecvACK\tRecvNAK");
        try {
            while (!finished) {
                Thread.sleep(1000L);
                socket.updateMonitor(false);
                System.out.printf("%.2f\t\t%.2f\t%d\t%.2f\t\t\t%d\t%d\n", socket.monitor().mbpsSendRate, socket.monitor().msRTT, socket.monitor().pktCongestionWindow, socket.monitor().usPktSndPeriod, socket.monitor().pktRecvACK, socket.monitor().pktRecvNAK);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

