/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.locators;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.support.locators.RelativeLocatorScript;

public class RelativeLocator {
    private static final Json JSON = new Json();
    private static final int CLOSE_IN_PIXELS = 50;

    public static RelativeBy with(By by) {
        Require.nonNull((String)"By to look for", (Object)by);
        return new RelativeBy(by);
    }

    private static Object asAtomLocatorParameter(Object object) {
        if (object instanceof WebElement) {
            return object;
        }
        if (!(object instanceof By)) {
            throw new IllegalArgumentException("Expected locator to be either an element or a By: " + object);
        }
        RelativeLocator.assertLocatorCanBeSerialized(object);
        Map raw = (Map)JSON.toType(JSON.toJson(object), Json.MAP_TYPE);
        if (!(raw.get("using") instanceof String)) {
            throw new JsonException("Expected JSON encoded form of locator to have a 'using' field. " + raw);
        }
        if (!raw.containsKey("value")) {
            throw new JsonException("Expected JSON encoded form of locator to have a 'value' field: " + raw);
        }
        return Map.of((String)raw.get("using"), raw.get("value"));
    }

    private static void assertLocatorCanBeSerialized(Object locator) {
        Require.nonNull((String)"Locator", (Object)locator);
        Class<?> clazz = locator.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                clazz.getDeclaredMethod("toJson", new Class[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException("Locator must be serializable to JSON using a `toJson` method. " + locator);
    }

    public static class RelativeBy
    extends By
    implements By.Remotable {
        private final Object root;
        private final List<Map<String, Object>> filters;

        private RelativeBy(Object rootLocator) {
            this(rootLocator, List.of());
        }

        private RelativeBy(Object rootLocator, List<Map<String, Object>> filters) {
            if (rootLocator instanceof By) {
                RelativeLocator.assertLocatorCanBeSerialized(rootLocator);
                rootLocator = RelativeLocator.asAtomLocatorParameter(rootLocator);
            } else if (rootLocator instanceof Map) {
                if (((Map)rootLocator).keySet().size() != 1) {
                    throw new IllegalArgumentException("Root locators as find element payload must only have a single key: " + rootLocator);
                }
            } else if (!(rootLocator instanceof WebElement)) {
                throw new IllegalArgumentException("Root locator must be an element or a locator: " + rootLocator);
            }
            this.root = Require.nonNull((String)"Root locator", (Object)rootLocator);
            this.filters = List.copyOf((Collection)Require.nonNull((String)"Filters", filters));
        }

        public RelativeBy above(WebElement element) {
            Require.nonNull((String)"Element to search above of", (Object)element);
            return this.simpleDirection("above", element);
        }

        public RelativeBy above(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("above", locator);
        }

        public RelativeBy below(WebElement element) {
            Require.nonNull((String)"Element to search below of", (Object)element);
            return this.simpleDirection("below", element);
        }

        public RelativeBy below(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("below", locator);
        }

        public RelativeBy toLeftOf(WebElement element) {
            Require.nonNull((String)"Element to search to left of", (Object)element);
            return this.simpleDirection("left", element);
        }

        public RelativeBy toLeftOf(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("left", locator);
        }

        public RelativeBy toRightOf(WebElement element) {
            Require.nonNull((String)"Element to search to right of", (Object)element);
            return this.simpleDirection("right", element);
        }

        public RelativeBy toRightOf(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("right", locator);
        }

        public RelativeBy near(WebElement element) {
            Require.nonNull((String)"Element to search near", (Object)element);
            return this.near(element, 50);
        }

        public RelativeBy near(WebElement element, int atMostDistanceInPixels) {
            Require.nonNull((String)"Element to search near", (Object)element);
            Require.positive((String)"Distance", (Integer)atMostDistanceInPixels);
            return this.near((Object)element, atMostDistanceInPixels);
        }

        public RelativeBy near(By locator) {
            Require.nonNull((String)"Locator", (Object)locator);
            return this.near((Object)locator, 50);
        }

        public RelativeBy near(By locator, int atMostDistanceInPixels) {
            Require.nonNull((String)"Locator", (Object)locator);
            Require.positive((String)"Distance", (Integer)atMostDistanceInPixels);
            return this.near((Object)locator, atMostDistanceInPixels);
        }

        private RelativeBy near(Object locator, int atMostDistanceInPixels) {
            Require.nonNull((String)"Locator", (Object)locator);
            Require.positive((String)"Distance", (Integer)atMostDistanceInPixels);
            return new RelativeBy(this.root, this.amend(Map.of("kind", "near", "args", List.of(RelativeLocator.asAtomLocatorParameter(locator), Integer.valueOf(atMostDistanceInPixels)))));
        }

        public List<WebElement> findElements(SearchContext context) {
            JavascriptExecutor js = this.getJavascriptExecutor(context);
            List elements = (List)js.executeScript(RelativeLocatorScript.FIND_ELEMENTS, new Object[]{RelativeLocator.asAtomLocatorParameter((Object)this)});
            return elements;
        }

        private RelativeBy simpleDirection(String direction, Object locator) {
            Require.nonNull((String)"Direction to search in", (Object)direction);
            Require.nonNull((String)"Locator", (Object)locator);
            return new RelativeBy(this.root, this.amend(Map.of("kind", direction, "args", List.of(RelativeLocator.asAtomLocatorParameter(locator)))));
        }

        private List<Map<String, Object>> amend(Map<String, Object> toAdd) {
            return Stream.concat(this.filters.stream(), Stream.of(toAdd)).collect(Collectors.toUnmodifiableList());
        }

        public By.Remotable.Parameters getRemoteParameters() {
            return new By.Remotable.Parameters("relative", Map.of("root", this.root, "filters", this.filters));
        }

        private Map<String, Object> toJson() {
            return Map.of("using", "relative", "value", Map.of("root", this.root, "filters", this.filters));
        }
    }
}

