/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.sql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.sql.ResultSetImpl;

class ResultSetMetaDataImpl
implements ResultSetMetaData {
    private final ResultSetImpl resultSet;
    private final Tuple metadataTuple;
    private final Tuple firstTuple;

    ResultSetMetaDataImpl(ResultSetImpl resultSet) {
        this.resultSet = resultSet;
        this.metadataTuple = this.resultSet.getMetadataTuple();
        this.firstTuple = this.resultSet.getFirstTuple();
    }

    private Class getColumnClass(int column) throws SQLException {
        Object o = this.firstTuple.get(this.getColumnLabel(column));
        if (o == null) {
            return String.class;
        }
        return o.getClass();
    }

    @Override
    public int getColumnCount() throws SQLException {
        List<String> fields = this.metadataTuple.getStrings("fields");
        if (fields == null) {
            throw new SQLException("Unable to determine fields for column count");
        }
        return fields.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnLabel(column).length();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        Map aliases = (Map)this.metadataTuple.get("aliases");
        return (String)aliases.get(this.getColumnName(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        List<String> columns = this.metadataTuple.getStrings("fields");
        if (column < 1 || column > columns.size()) {
            throw new SQLException("Column index " + column + " is not valid");
        }
        return columns.get(column - 1);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        switch (this.getColumnTypeName(column)) {
            case "String": {
                return 12;
            }
            case "Integer": {
                return 4;
            }
            case "Long": {
                return 8;
            }
            case "Double": {
                return 8;
            }
        }
        return 2000;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnClass(column).getSimpleName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumnClass(column).getTypeName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

