/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.cdx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.archive.format.cdx.CDXFile;
import org.archive.format.cdx.CDXInputSource;
import org.archive.format.gzip.zipnum.ZipNumIndex;
import org.archive.format.gzip.zipnum.ZipNumParams;
import org.archive.util.iterator.CloseableCompositeIterator;
import org.archive.util.iterator.CloseableIterator;
import org.archive.util.iterator.SortedCompositeIterator;

public class MultiCDXInputSource
implements CDXInputSource {
    private static final Logger LOGGER = Logger.getLogger(MultiCDXInputSource.class.getName());
    protected List<CDXInputSource> cdx;
    public static final Comparator<String> defaultComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    };
    public static final Comparator<String> defaultReverseComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return -s1.compareTo(s2);
        }
    };
    protected Comparator<String> comparator = defaultComparator;
    protected Comparator<String> reverseComparator = defaultReverseComparator;

    public List<CDXInputSource> getCdx() {
        return this.cdx;
    }

    public void setCdx(List<CDXInputSource> cdx) {
        this.cdx = cdx;
    }

    public void setCdxUris(List<String> cdxUris) throws IOException {
        this.cdx = new ArrayList<CDXInputSource>();
        for (String uri : cdxUris) {
            if (uri.endsWith(".cdx") || uri.endsWith(".cdx.gz")) {
                this.cdx.add(new CDXFile(uri));
                continue;
            }
            if (!uri.endsWith("ALL.summary") || !uri.contains("/")) continue;
            this.cdx.add(ZipNumIndex.createIndexWithSummaryPath(uri));
        }
    }

    @Override
    public CloseableIterator<String> getCDXIterator(String key, String prefix, boolean exact, ZipNumParams params) throws IOException {
        SortedCompositeIterator<String> scitr = new SortedCompositeIterator<String>(this.cdx.size(), params.isReverse() ? this.reverseComparator : this.comparator);
        CloseableIterator<String> iter = null;
        for (CDXInputSource cdxReader : this.cdx) {
            try {
                iter = cdxReader.getCDXIterator(key, prefix, exact, params);
                scitr.addIterator(iter);
            }
            catch (IOException io) {
                LOGGER.warning(io.toString());
            }
        }
        return scitr;
    }

    public CloseableIterator<String> createSeqIterator(String key, String start, String end, ZipNumParams params) {
        CloseableCompositeIterator<String> composite = new CloseableCompositeIterator<String>();
        LazyInitIterator iter = null;
        for (int i = 0; i < this.cdx.size(); ++i) {
            try {
                CDXInputSource cdxReader = this.cdx.get(i);
                iter = i == this.cdx.size() - 1 ? cdxReader.getCDXIterator(key, start, end, params) : new LazyInitIterator(cdxReader, key, start, end, params);
                if (!params.isReverse()) {
                    composite.addLast(iter);
                    continue;
                }
                composite.addFirst(iter);
                continue;
            }
            catch (IOException io) {
                LOGGER.warning(io.toString());
            }
        }
        return composite;
    }

    @Override
    public CloseableIterator<String> getCDXIterator(String key, String start, String end, ZipNumParams params) throws IOException {
        if (params.isSequential()) {
            return this.createSeqIterator(key, start, end, params);
        }
        SortedCompositeIterator<String> scitr = new SortedCompositeIterator<String>(this.cdx.size(), params.isReverse() ? this.reverseComparator : this.comparator);
        CloseableIterator<String> iter = null;
        for (CDXInputSource cdxReader : this.cdx) {
            try {
                iter = cdxReader.getCDXIterator(key, start, end, params);
                scitr.addIterator(iter);
            }
            catch (IOException io) {
                LOGGER.warning(io.toString());
            }
        }
        return scitr;
    }

    @Override
    public long getTotalLines() {
        long sum = 0L;
        for (CDXInputSource cdxReader : this.cdx) {
            sum += cdxReader.getTotalLines();
        }
        return sum;
    }

    protected static class LazyInitIterator
    implements CloseableIterator<String> {
        CDXInputSource source;
        CloseableIterator<String> iter;
        boolean failed = false;
        String key;
        String start;
        String end;
        ZipNumParams params;

        protected LazyInitIterator(CDXInputSource source, String key, String start, String end, ZipNumParams params) {
            this.key = key;
            this.start = start;
            this.end = end;
            this.params = params;
            this.source = source;
        }

        protected void initIter() {
            if (this.iter != null) {
                return;
            }
            try {
                this.iter = this.source.getCDXIterator(this.key, this.start, this.end, this.params);
            }
            catch (IOException io) {
                LOGGER.warning(io.toString());
                this.iter = null;
            }
        }

        @Override
        public boolean hasNext() {
            this.initIter();
            if (this.iter == null) {
                return false;
            }
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            this.initIter();
            if (this.iter == null) {
                return null;
            }
            return (String)this.iter.next();
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() throws IOException {
            if (this.iter != null) {
                this.iter.close();
            }
        }
    }
}

