/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.cdx;

import org.archive.format.cdx.CDX09Line;
import org.archive.format.cdx.CDX11Line;
import org.archive.format.cdx.CDXFieldConstants;
import org.archive.format.cdx.CDXLine;
import org.archive.format.cdx.CDXLineFactory;
import org.archive.format.cdx.FieldSplitFormat;

public class StandardCDXLineFactory
implements CDXLineFactory,
CDXFieldConstants {
    public static final FieldSplitFormat cdx11 = new FieldSplitFormat("urlkey", "timestamp", "original", "mimetype", "statuscode", "digest", "redirect", "robotflags", "length", "offset", "filename");
    public static final FieldSplitFormat cdx09 = new FieldSplitFormat("urlkey", "timestamp", "original", "mimetype", "statuscode", "digest", "redirect", "offset", "filename");
    protected final FieldSplitFormat parseFormat;

    public StandardCDXLineFactory(String formatName) {
        this.parseFormat = formatName == null ? cdx09 : (formatName.equals("cdx11") ? cdx11 : cdx09);
    }

    protected StandardCDXLineFactory(FieldSplitFormat parseFormat) {
        this.parseFormat = parseFormat;
    }

    @Override
    public FieldSplitFormat getParseFormat() {
        return this.parseFormat;
    }

    public CDXLine createStandardCDXLine(String input) {
        if (this.parseFormat == cdx11) {
            return new CDX11Line(input, this.parseFormat);
        }
        if (this.parseFormat == cdx09) {
            return new CDX09Line(input, this.parseFormat);
        }
        return new CDXLine(input, this.parseFormat);
    }

    @Override
    public CDXLine createStandardCDXLine(String input, FieldSplitFormat exFormat) {
        if (this.parseFormat == cdx11) {
            return new CDX11Line(input, exFormat);
        }
        if (this.parseFormat == cdx09) {
            return new CDX09Line(input, exFormat);
        }
        return new CDXLine(input, exFormat);
    }
}

