/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import com.google.common.io.ByteStreams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.archive.util.binsearch.AbstractSeekableLineReader;

public class RandomAccessFileSeekableLineReader
extends AbstractSeekableLineReader {
    private RandomAccessFile raf;

    public RandomAccessFileSeekableLineReader(RandomAccessFile raf, int blockSize) {
        super(blockSize);
        this.raf = raf;
    }

    @Override
    public InputStream doSeekLoad(long offset, int maxLength) throws IOException {
        this.raf.seek(offset);
        FileInputStream fis = new FileInputStream(this.raf.getFD());
        if (maxLength > 0) {
            return ByteStreams.limit((InputStream)fis, (long)maxLength);
        }
        return fis;
    }

    public long getOffset() throws IOException {
        if (this.closed) {
            return 0L;
        }
        return this.raf.getFilePointer();
    }

    @Override
    public void doClose() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public long getSize() throws IOException {
        return this.raf.length();
    }
}

