/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.MessageSupplier;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkPrimaryExecutionContext;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.bulk.BulkShardResponse;
import org.opensearch.action.bulk.MappingUpdatePerformer;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.action.support.replication.TransportWriteAction;
import org.opensearch.action.update.UpdateHelper;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.action.index.MappingUpdatedAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.IndexingPressureService;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.get.GetResult;
import org.opensearch.index.mapper.MapperException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.SystemIndices;
import org.opensearch.node.NodeClosedException;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private static final Logger logger = LogManager.getLogger(TransportShardBulkAction.class);
    private static final Function<IndexShard, String> EXECUTOR_NAME_FUNCTION = shard -> {
        if (shard.indexSettings().getIndexMetadata().isSystem()) {
            return "system_write";
        }
        return "write";
    };
    private final UpdateHelper updateHelper;
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexingPressureService indexingPressureService, SystemIndices systemIndices) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, BulkShardRequest::new, BulkShardRequest::new, EXECUTOR_NAME_FUNCTION, false, indexingPressureService, systemIndices);
        this.updateHelper = updateHelper;
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    @Override
    protected TransportRequestOptions transportOptions(Settings settings) {
        return BulkAction.INSTANCE.transportOptions(settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance(StreamInput in) throws IOException {
        return new BulkShardResponse(in);
    }

    @Override
    protected void dispatchedShardOperationOnPrimary(BulkShardRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener) {
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, request.timeout(), logger, this.threadPool.getThreadContext());
        TransportShardBulkAction.performOnPrimary(request, primary, this.updateHelper, this.threadPool::absoluteTimeInMillis, (update, shardId, type, mappingListener) -> {
            assert (update != null);
            assert (shardId != null);
            this.mappingUpdatedAction.updateMappingOnMaster(shardId.getIndex(), type, update, mappingListener);
        }, mappingUpdateListener -> observer.waitForNextChange(new ClusterStateObserver.Listener((ActionListener)mappingUpdateListener){
            final /* synthetic */ ActionListener val$mappingUpdateListener;
            {
                this.val$mappingUpdateListener = actionListener;
            }

            @Override
            public void onNewClusterState(ClusterState state) {
                this.val$mappingUpdateListener.onResponse(null);
            }

            @Override
            public void onClusterServiceClose() {
                this.val$mappingUpdateListener.onFailure(new NodeClosedException(TransportShardBulkAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                this.val$mappingUpdateListener.onFailure(new MapperException("timed out while waiting for a dynamic mapping update"));
            }
        }), listener, this.threadPool, this.executor(primary));
    }

    @Override
    protected long primaryOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    public static void performOnPrimary(final BulkShardRequest request, final IndexShard primary, final UpdateHelper updateHelper, final LongSupplier nowInMillisSupplier, final MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener, final ThreadPool threadPool, final String executorName) {
        new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(listener){
            private final Executor executor;
            private final BulkPrimaryExecutionContext context;
            {
                super(listener);
                this.executor = threadPool.executor(executorName);
                this.context = new BulkPrimaryExecutionContext(request, primary);
            }

            @Override
            protected void doRun() throws Exception {
                while (this.context.hasMoreOperationsToExecute()) {
                    if (!TransportShardBulkAction.executeBulkItemRequest(this.context, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate, ActionListener.wrap(v -> this.executor.execute(this), this::onRejection))) {
                        return;
                    }
                    assert (this.context.isInitial());
                }
                this.finishRequest();
            }

            @Override
            public void onRejection(final Exception e) {
                this.executor.execute(new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(this.listener){

                    @Override
                    protected void doRun() {
                        while (context.hasMoreOperationsToExecute()) {
                            context.setRequestToExecute(context.getCurrent());
                            Object docWriteRequest = context.getRequestToExecute();
                            TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, docWriteRequest.opType() == DocWriteRequest.OpType.DELETE, docWriteRequest.version()), context, null);
                        }
                        this.finishRequest();
                    }

                    @Override
                    public boolean isForceExecution() {
                        return true;
                    }
                });
            }

            private void finishRequest() {
                ActionListener.completeWith(this.listener, () -> new TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>(this.context.getBulkShardRequest(), this.context.buildShardResponse(), this.context.getLocationToSync(), null, this.context.getPrimary(), logger));
            }
        }.run();
    }

    static boolean executeBulkItemRequest(final BulkPrimaryExecutionContext context, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, final ActionListener<Void> itemDoneListener) throws Exception {
        Engine.Result result;
        ReplicatedWriteRequest request;
        boolean isDelete;
        UpdateHelper.Result updateResult;
        DocWriteRequest.OpType opType = context.getCurrent().opType();
        if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)context.getCurrent();
            try {
                updateResult = updateHelper.prepare(updateRequest, context.getPrimary(), nowInMillisSupplier);
            }
            catch (Exception failure) {
                Engine.IndexResult result2 = new Engine.IndexResult(failure, updateRequest.version());
                context.setRequestToExecute(updateRequest);
                context.markOperationAsExecuted(result2);
                context.markAsCompleted(context.getExecutionResult());
                return true;
            }
            switch (updateResult.getResponseResult()) {
                case CREATED: 
                case UPDATED: {
                    IndexRequest indexRequest = (IndexRequest)updateResult.action();
                    IndexMetadata metadata = context.getPrimary().indexSettings().getIndexMetadata();
                    MappingMetadata mappingMd = metadata.mappingOrDefault();
                    indexRequest.process(metadata.getCreationVersion(), mappingMd, updateRequest.concreteIndex());
                    context.setRequestToExecute(indexRequest);
                    break;
                }
                case DELETED: {
                    context.setRequestToExecute((DocWriteRequest)updateResult.action());
                    break;
                }
                case NOOP: {
                    context.markOperationAsNoOp((DocWriteResponse)updateResult.action());
                    context.markAsCompleted(context.getExecutionResult());
                    return true;
                }
                default: {
                    throw new IllegalStateException("Illegal update operation " + updateResult.getResponseResult());
                }
            }
        } else {
            context.setRequestToExecute(context.getCurrent());
            updateResult = null;
        }
        assert (context.getRequestToExecute() != null);
        final IndexShard primary = context.getPrimary();
        final long version = context.getRequestToExecute().version();
        boolean bl = isDelete = context.getRequestToExecute().opType() == DocWriteRequest.OpType.DELETE;
        if (isDelete) {
            request = (DeleteRequest)context.getRequestToExecute();
            result = primary.applyDeleteOperationOnPrimary(version, ((DeleteRequest)request).type(), ((DeleteRequest)request).id(), ((DeleteRequest)request).versionType(), ((DeleteRequest)request).ifSeqNo(), ((DeleteRequest)request).ifPrimaryTerm());
        } else {
            request = (IndexRequest)context.getRequestToExecute();
            result = primary.applyIndexOperationOnPrimary(version, ((IndexRequest)request).versionType(), new SourceToParse(request.index(), ((IndexRequest)request).type(), ((IndexRequest)request).id(), ((IndexRequest)request).source(), ((IndexRequest)request).getContentType(), ((IndexRequest)request).routing()), ((IndexRequest)request).ifSeqNo(), ((IndexRequest)request).ifPrimaryTerm(), ((IndexRequest)request).getAutoGeneratedTimestamp(), ((IndexRequest)request).isRetry());
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            try {
                primary.mapperService().merge(context.getRequestToExecute().type(), new CompressedXContent((ToXContent)result.getRequiredMappingUpdate(), XContentType.JSON, ToXContent.EMPTY_PARAMS), MapperService.MergeReason.MAPPING_UPDATE_PREFLIGHT);
            }
            catch (Exception e) {
                logger.info(() -> new ParameterizedMessage("{} mapping update rejected by primary", (Object)primary.shardId()), (Throwable)e);
                TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, isDelete, version), context, updateResult);
                return true;
            }
            mappingUpdater.updateMappings(result.getRequiredMappingUpdate(), primary.shardId(), context.getRequestToExecute().type(), new ActionListener<Void>(){

                @Override
                public void onResponse(Void v) {
                    context.markAsRequiringMappingUpdate();
                    waitForMappingUpdate.accept(ActionListener.runAfter(new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void v) {
                            assert (context.requiresWaitingForMappingUpdate());
                            context.resetForExecutionForRetry();
                        }

                        @Override
                        public void onFailure(Exception e) {
                            context.failOnMappingUpdate(e);
                        }
                    }, () -> itemDoneListener.onResponse(null)));
                }

                @Override
                public void onFailure(Exception e) {
                    TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, isDelete, version), context, updateResult);
                    assert (context.isInitial());
                    itemDoneListener.onResponse(null);
                }
            });
            return false;
        }
        TransportShardBulkAction.onComplete(result, context, updateResult);
        return true;
    }

    private static Engine.Result exceptionToResult(Exception e, IndexShard primary, boolean isDelete, long version) {
        return isDelete ? primary.getFailedDeleteResult(e, version) : primary.getFailedIndexResult(e, version);
    }

    private static void onComplete(Engine.Result r, BulkPrimaryExecutionContext context, UpdateHelper.Result updateResult) {
        BulkItemResponse response;
        context.markOperationAsExecuted(r);
        DocWriteRequest<?> docWriteRequest = context.getCurrent();
        DocWriteRequest.OpType opType = docWriteRequest.opType();
        boolean isUpdate = opType == DocWriteRequest.OpType.UPDATE;
        BulkItemResponse executionResult = context.getExecutionResult();
        boolean isFailed = executionResult.isFailed();
        if (isUpdate && isFailed && TransportShardBulkAction.isConflictException(executionResult.getFailure().getCause()) && context.getRetryCounter() < ((UpdateRequest)docWriteRequest).retryOnConflict()) {
            context.resetForExecutionForRetry();
            return;
        }
        if (isUpdate) {
            response = TransportShardBulkAction.processUpdateResponse((UpdateRequest)docWriteRequest, context.getConcreteIndex(), executionResult, updateResult);
        } else {
            if (isFailed) {
                Exception failure = executionResult.getFailure().getCause();
                MessageSupplier messageSupplier = () -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{context.getPrimary().shardId(), opType.getLowercase(), docWriteRequest});
                if (TransportShardBulkAction.isConflictException(failure)) {
                    logger.trace(messageSupplier, (Throwable)failure);
                } else {
                    logger.debug(messageSupplier, (Throwable)failure);
                }
            }
            response = executionResult;
        }
        context.markAsCompleted(response);
        assert (context.isInitial());
    }

    private static boolean isConflictException(Exception e) {
        return ExceptionsHelper.unwrapCause(e) instanceof VersionConflictEngineException;
    }

    static BulkItemResponse processUpdateResponse(UpdateRequest updateRequest, String concreteIndex, BulkItemResponse operationResponse, UpdateHelper.Result translate) {
        BulkItemResponse response;
        if (operationResponse.isFailed()) {
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, operationResponse.getFailure());
        } else {
            UpdateResponse updateResponse;
            DocWriteResponse.Result translatedResult = translate.getResponseResult();
            if (translatedResult == DocWriteResponse.Result.CREATED || translatedResult == DocWriteResponse.Result.UPDATED) {
                IndexRequest updateIndexRequest = (IndexRequest)translate.action();
                IndexResponse indexResponse = (IndexResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getType(), indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), indexResponse.getResult());
                if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource()) {
                    BytesReference indexSourceAsBytes = updateIndexRequest.source();
                    Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true, updateIndexRequest.getContentType());
                    updateResponse.setGetResult(UpdateHelper.extractGetResult(updateRequest, concreteIndex, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), (Map)sourceAndContent.v2(), (XContentType)sourceAndContent.v1(), indexSourceAsBytes));
                }
            } else if (translatedResult == DocWriteResponse.Result.DELETED) {
                DeleteResponse deleteResponse = (DeleteResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getType(), deleteResponse.getId(), deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), deleteResponse.getResult());
                GetResult getResult = UpdateHelper.extractGetResult(updateRequest, concreteIndex, deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null);
                updateResponse.setGetResult(getResult);
            } else {
                throw new IllegalArgumentException("unknown operation type: " + translatedResult);
            }
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, updateResponse);
        }
        return response;
    }

    @Override
    protected void dispatchedShardOperationOnReplica(BulkShardRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            Translog.Location location = TransportShardBulkAction.performOnReplica(request, replica);
            return new TransportWriteAction.WriteReplicaResult<BulkShardRequest>(request, location, null, replica, logger);
        });
    }

    @Override
    protected long replicaOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    public static Translog.Location performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        for (int i = 0; i < request.items().length; ++i) {
            Engine.Result operationResult;
            BulkItemRequest item = request.items()[i];
            BulkItemResponse response = item.getPrimaryResponse();
            if (item.getPrimaryResponse().isFailed()) {
                if (response.getFailure().getSeqNo() == -2L) continue;
                long primaryTerm = response.getFailure().getTerm() == 0L ? replica.getOperationPrimaryTerm() : response.getFailure().getTerm();
                operationResult = replica.markSeqNoAsNoop(response.getFailure().getSeqNo(), primaryTerm, response.getFailure().getMessage());
            } else {
                if (((DocWriteResponse)response.getResponse()).getResult() == DocWriteResponse.Result.NOOP) continue;
                assert (((DocWriteResponse)response.getResponse()).getSeqNo() != -2L);
                operationResult = TransportShardBulkAction.performOpOnReplica(response.getResponse(), item.request(), replica);
            }
            assert (operationResult != null) : "operation result must never be null when primary response has no failure";
            location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
        }
        return location;
    }

    private static Engine.Result performOpOnReplica(DocWriteResponse primaryResponse, DocWriteRequest<?> docWriteRequest, IndexShard replica) throws Exception {
        Engine.Result result;
        switch (docWriteRequest.opType()) {
            case CREATE: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                ShardId shardId = replica.shardId();
                SourceToParse sourceToParse = new SourceToParse(shardId.getIndexName(), indexRequest.type(), indexRequest.id(), indexRequest.source(), indexRequest.getContentType(), indexRequest.routing());
                result = replica.applyIndexOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), indexRequest.getAutoGeneratedTimestamp(), indexRequest.isRetry(), sourceToParse);
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                result = replica.applyDeleteOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), deleteRequest.type(), deleteRequest.id());
                break;
            }
            default: {
                assert (false) : "Unexpected request operation type on replica: " + docWriteRequest + ";primary result: " + primaryResponse;
                throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
            }
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
        }
        return result;
    }
}

