/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.xcontent.XContentBuilder;

public final class FieldMemoryStats
implements Writeable,
Iterable<ObjectLongCursor<String>> {
    private final ObjectLongHashMap<String> stats;

    public FieldMemoryStats(ObjectLongHashMap<String> stats) {
        this.stats = Objects.requireNonNull(stats, "status must be non-null");
        assert (!stats.containsKey(null));
    }

    public FieldMemoryStats(StreamInput input) throws IOException {
        int size = input.readVInt();
        this.stats = new ObjectLongHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.stats.put((Object)input.readString(), input.readVLong());
        }
    }

    public void add(FieldMemoryStats fieldMemoryStats) {
        for (ObjectLongCursor entry : fieldMemoryStats.stats) {
            this.stats.addTo((Object)((String)entry.key), entry.value);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.stats.size());
        for (ObjectLongCursor entry : this.stats) {
            out.writeString((String)entry.key);
            out.writeVLong(entry.value);
        }
    }

    public void toXContent(XContentBuilder builder, String key, String rawKey, String readableKey) throws IOException {
        builder.startObject(key);
        for (ObjectLongCursor entry : this.stats) {
            builder.startObject((String)entry.key);
            builder.humanReadableField(rawKey, readableKey, (Object)new ByteSizeValue(entry.value));
            builder.endObject();
        }
        builder.endObject();
    }

    public FieldMemoryStats copy() {
        return new FieldMemoryStats((ObjectLongHashMap<String>)this.stats.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMemoryStats that = (FieldMemoryStats)o;
        return Objects.equals(this.stats, that.stats);
    }

    public int hashCode() {
        return Objects.hash(this.stats);
    }

    @Override
    public Iterator<ObjectLongCursor<String>> iterator() {
        return this.stats.iterator();
    }

    public long get(String field) {
        return this.stats.get((Object)field);
    }

    public boolean containsField(String field) {
        return this.stats.containsKey((Object)field);
    }
}

