/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.util.CuckooFilter;

public class SetBackedScalingCuckooFilter
implements Writeable {
    private static final int FILTER_CAPACITY = 1000000;
    Set<Long> hashes;
    List<CuckooFilter> filters;
    private final int threshold;
    private final Random rng;
    private final int capacity;
    private final double fpp;
    private Consumer<Long> breaker;
    private int numBuckets;
    private int bitsPerEntry;
    private int fingerprintMask;
    private MurmurHash3.Hash128 scratchHash;
    private boolean isSetMode;

    public SetBackedScalingCuckooFilter(int threshold, Random rng, double fpp) {
        this.breaker = aLong -> {};
        this.numBuckets = 0;
        this.bitsPerEntry = 0;
        this.fingerprintMask = 0;
        this.scratchHash = new MurmurHash3.Hash128();
        this.isSetMode = true;
        if (threshold <= 0) {
            throw new IllegalArgumentException("[threshold] must be a positive integer");
        }
        if (threshold * 2 > 1000000) {
            throw new IllegalArgumentException("[threshold] must be smaller than [500000]");
        }
        if (fpp < 0.0) {
            throw new IllegalArgumentException("[fpp] must be a positive double");
        }
        this.hashes = new HashSet<Long>(threshold);
        this.threshold = threshold;
        this.rng = rng;
        this.capacity = 1000000;
        this.fpp = fpp;
    }

    public SetBackedScalingCuckooFilter(SetBackedScalingCuckooFilter other) {
        this.breaker = aLong -> {};
        this.numBuckets = 0;
        this.bitsPerEntry = 0;
        this.fingerprintMask = 0;
        this.scratchHash = new MurmurHash3.Hash128();
        this.isSetMode = true;
        this.threshold = other.threshold;
        this.isSetMode = other.isSetMode;
        this.rng = other.rng;
        this.breaker = other.breaker;
        this.capacity = other.capacity;
        this.fpp = other.fpp;
        if (this.isSetMode) {
            this.hashes = new HashSet<Long>(other.hashes);
        } else {
            this.filters = new ArrayList<CuckooFilter>(other.filters);
            this.numBuckets = this.filters.get(0).getNumBuckets();
            this.fingerprintMask = this.filters.get(0).getFingerprintMask();
            this.bitsPerEntry = this.filters.get(0).getBitsPerEntry();
        }
    }

    public SetBackedScalingCuckooFilter(StreamInput in, Random rng) throws IOException {
        this.breaker = aLong -> {};
        this.numBuckets = 0;
        this.bitsPerEntry = 0;
        this.fingerprintMask = 0;
        this.scratchHash = new MurmurHash3.Hash128();
        this.isSetMode = true;
        this.threshold = in.readVInt();
        this.isSetMode = in.readBoolean();
        this.rng = rng;
        this.capacity = in.readVInt();
        this.fpp = in.readDouble();
        if (this.isSetMode) {
            this.hashes = in.readSet(StreamInput::readZLong);
        } else {
            this.filters = in.readList(in12 -> new CuckooFilter(in12, rng));
            this.numBuckets = this.filters.get(0).getNumBuckets();
            this.fingerprintMask = this.filters.get(0).getFingerprintMask();
            this.bitsPerEntry = this.filters.get(0).getBitsPerEntry();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.threshold);
        out.writeBoolean(this.isSetMode);
        out.writeVInt(this.capacity);
        out.writeDouble(this.fpp);
        if (this.isSetMode) {
            out.writeCollection(this.hashes, StreamOutput::writeZLong);
        } else {
            out.writeList(this.filters);
        }
    }

    public void registerBreaker(Consumer<Long> breaker) {
        this.breaker = Objects.requireNonNull(breaker, "Circuit Breaker Consumer cannot be null");
        breaker.accept(this.getSizeInBytes());
    }

    public boolean mightContain(BytesRef value) {
        MurmurHash3.Hash128 hash = MurmurHash3.hash128(value.bytes, value.offset, value.length, 0L, this.scratchHash);
        return this.mightContainHash(hash.h1);
    }

    public boolean mightContain(long value) {
        long hash = MurmurHash3.murmur64(value);
        return this.mightContainHash(hash);
    }

    private boolean mightContainHash(long hash) {
        if (this.isSetMode) {
            return this.hashes.contains(hash);
        }
        int bucket = CuckooFilter.hashToIndex((int)hash, this.numBuckets);
        int fingerprint = CuckooFilter.fingerprint((int)(hash >> 32), this.bitsPerEntry, this.fingerprintMask);
        int alternateIndex = CuckooFilter.alternateIndex(bucket, fingerprint, this.numBuckets);
        for (CuckooFilter filter : this.filters) {
            if (!filter.mightContainFingerprint(bucket, fingerprint, alternateIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean mightContainFingerprint(int bucket, int fingerprint) {
        int alternateIndex = CuckooFilter.alternateIndex(bucket, fingerprint, this.numBuckets);
        for (CuckooFilter filter : this.filters) {
            if (!filter.mightContainFingerprint(bucket, fingerprint, alternateIndex)) continue;
            return true;
        }
        return false;
    }

    public void add(BytesRef value) {
        MurmurHash3.Hash128 hash = MurmurHash3.hash128(value.bytes, value.offset, value.length, 0L, this.scratchHash);
        this.addHash(hash.h1);
    }

    public void add(long value) {
        this.addHash(MurmurHash3.murmur64(value));
    }

    private void addHash(long hash) {
        if (this.isSetMode) {
            this.hashes.add(hash);
            this.maybeConvert();
            return;
        }
        boolean success = this.filters.get(this.filters.size() - 1).add(hash);
        if (!success) {
            CuckooFilter t = new CuckooFilter(this.capacity, this.fpp, this.rng);
            t.add(hash);
            this.filters.add(t);
            this.breaker.accept(t.getSizeInBytes());
        }
    }

    private void maybeConvert() {
        if (this.isSetMode && this.hashes.size() > this.threshold) {
            this.convert();
        }
    }

    void convert() {
        if (!this.isSetMode) {
            throw new IllegalStateException("Cannot convert SetBackedScalingCuckooFilter to approximate when it has already been converted.");
        }
        long oldSize = this.getSizeInBytes();
        this.filters = new ArrayList<CuckooFilter>();
        CuckooFilter t = new CuckooFilter(this.capacity, this.fpp, this.rng);
        this.numBuckets = t.getNumBuckets();
        this.fingerprintMask = t.getFingerprintMask();
        this.bitsPerEntry = t.getBitsPerEntry();
        this.hashes.forEach(t::add);
        this.filters.add(t);
        this.hashes = null;
        this.isSetMode = false;
        this.breaker.accept(-oldSize);
        this.breaker.accept(this.getSizeInBytes());
    }

    public long getSizeInBytes() {
        long bytes = 13L;
        if (this.hashes != null) {
            bytes = this.hashes.size() * 16;
        }
        if (this.filters != null) {
            bytes += this.filters.stream().mapToLong(CuckooFilter::getSizeInBytes).sum();
        }
        return bytes;
    }

    public void merge(SetBackedScalingCuckooFilter other) {
        if (this.threshold != other.threshold) {
            throw new IllegalStateException("Cannot merge other CuckooFilter because thresholds do not match: [" + this.threshold + "] vs [" + other.threshold + "]");
        }
        if (this.capacity != other.capacity) {
            throw new IllegalStateException("Cannot merge other CuckooFilter because capacities do not match: [" + this.capacity + "] vs [" + other.capacity + "]");
        }
        if (this.fpp != other.fpp) {
            throw new IllegalStateException("Cannot merge other CuckooFilter because precisions do not match: [" + this.fpp + "] vs [" + other.fpp + "]");
        }
        if (this.isSetMode && other.isSetMode) {
            this.hashes.addAll(other.hashes);
            this.maybeConvert();
        } else if (this.isSetMode && !other.isSetMode) {
            this.convert();
            this.merge(other);
        } else if (!this.isSetMode && other.isSetMode) {
            other.hashes.forEach(this::add);
        } else {
            CuckooFilter currentFilter = this.filters.get(this.filters.size() - 1);
            for (CuckooFilter otherFilter : other.filters) {
                Iterator<long[]> iter = otherFilter.getBuckets();
                int bucket = 0;
                while (iter.hasNext()) {
                    long[] fingerprints;
                    for (long fingerprint : fingerprints = iter.next()) {
                        if (fingerprint == 0L || this.mightContainFingerprint(bucket, (int)fingerprint) || currentFilter.mergeFingerprint(bucket, (int)fingerprint)) continue;
                        CuckooFilter t = new CuckooFilter(this.capacity, this.fpp, this.rng);
                        this.filters.add(t);
                        this.breaker.accept(t.getSizeInBytes());
                        currentFilter = this.filters.get(this.filters.size() - 1);
                    }
                    ++bucket;
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.hashes, this.filters, this.threshold, this.isSetMode, this.capacity, this.fpp);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SetBackedScalingCuckooFilter that = (SetBackedScalingCuckooFilter)other;
        return Objects.equals(this.hashes, that.hashes) && Objects.equals(this.filters, that.filters) && Objects.equals(this.threshold, that.threshold) && Objects.equals(this.isSetMode, that.isSetMode) && Objects.equals(this.capacity, that.capacity) && Objects.equals(this.fpp, that.fpp);
    }
}

