/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.index.VersionType;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class RestGetAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in document get requests is deprecated, use the /{index}/_doc/{id} endpoint instead.";

    @Override
    public String getName() {
        return "document_get_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_doc/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_doc/{id}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/{type}/{id}")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] fields;
        GetRequest getRequest;
        if (request.hasParam("type")) {
            deprecationLogger.deprecate("get_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        } else {
            getRequest = new GetRequest(request.param("index"), request.param("id"));
        }
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("the parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or [_source] to load the field from _source");
        }
        String fieldsParam = request.param("stored_fields");
        if (fieldsParam != null && (fields = Strings.splitStringByCommaToArray(fieldsParam)) != null) {
            getRequest.storedFields(fields);
        }
        getRequest.version(RestActions.parseVersion(request));
        getRequest.versionType(VersionType.fromString(request.param("version_type"), getRequest.versionType()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> client.get(getRequest, (ActionListener<GetResponse>)new RestToXContentListener<GetResponse>(channel){

            @Override
            protected RestStatus getStatus(GetResponse response) {
                return response.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }
}

