/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.geogrid;

import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.opensearch.search.aggregations.bucket.geogrid.CellValues;

class BoundedCellValues
extends CellValues {
    private final GeoBoundingBox geoBoundingBox;

    protected BoundedCellValues(MultiGeoPointValues geoValues, int precision, CellIdSource.GeoPointLongEncoder encoder, GeoBoundingBox geoBoundingBox) {
        super(geoValues, precision, encoder);
        this.geoBoundingBox = geoBoundingBox;
    }

    @Override
    int advanceValue(GeoPoint target, int valuesIdx) {
        if (this.geoBoundingBox.pointInBounds(target.getLon(), target.getLat())) {
            this.values[valuesIdx] = this.encoder.encode(target.getLon(), target.getLat(), this.precision);
            return valuesIdx + 1;
        }
        return valuesIdx;
    }
}

