/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.fetcher;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.fetcher.FetchItem;
import org.apache.nutch.fetcher.FetchItemQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchItemQueues {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_ID = "default";
    Map<String, FetchItemQueue> queues = new ConcurrentHashMap<String, FetchItemQueue>();
    private Set<String> queuesMaxExceptions = new HashSet<String>();
    Iterator<Map.Entry<String, FetchItemQueue>> lastIterator = null;
    AtomicInteger totalSize = new AtomicInteger(0);
    Cache<Text, Optional<String>> redirectDedupCache = null;
    int maxThreads;
    long crawlDelay;
    long minCrawlDelay;
    long timelimit = -1L;
    int maxExceptionsPerQueue = -1;
    long exceptionsPerQueueDelay = -1L;
    long exceptionsPerQueueClearAfter = 1800000L;
    volatile boolean feederAlive = true;
    volatile boolean timoutReached = false;
    Configuration conf;
    public static final String QUEUE_MODE_HOST = "byHost";
    public static final String QUEUE_MODE_DOMAIN = "byDomain";
    public static final String QUEUE_MODE_IP = "byIP";
    String queueMode;

    public FetchItemQueues(Configuration conf) {
        this.conf = conf;
        this.maxThreads = conf.getInt("fetcher.threads.per.queue", 1);
        this.queueMode = conf.get("fetcher.queue.mode", QUEUE_MODE_HOST);
        this.queueMode = FetchItemQueues.checkQueueMode(this.queueMode);
        LOG.info("Using queue mode : {}", (Object)this.queueMode);
        this.crawlDelay = (long)(conf.getFloat("fetcher.server.delay", 1.0f) * 1000.0f);
        this.minCrawlDelay = (long)(conf.getFloat("fetcher.server.min.delay", 0.0f) * 1000.0f);
        this.timelimit = conf.getLong("fetcher.timelimit", -1L);
        this.maxExceptionsPerQueue = conf.getInt("fetcher.max.exceptions.per.queue", -1);
        this.exceptionsPerQueueDelay = (long)(conf.getFloat("fetcher.exceptions.per.queue.delay", 0.0f) * 1000.0f);
        this.exceptionsPerQueueClearAfter = (long)(conf.getFloat("fetcher.exceptions.per.queue.clear.after", 1800.0f) * 1000.0f);
        int dedupRedirMaxTime = conf.getInt("fetcher.redirect.dedupcache.seconds", -1);
        int dedupRedirMaxSize = conf.getInt("fetcher.redirect.dedupcache.size", 1000);
        if (dedupRedirMaxTime > 0 && dedupRedirMaxSize > 0) {
            this.redirectDedupCache = CacheBuilder.newBuilder().maximumSize((long)dedupRedirMaxSize).expireAfterWrite((long)dedupRedirMaxTime, TimeUnit.SECONDS).build();
        }
    }

    protected static String checkQueueMode(String queueMode) {
        if (!(queueMode.equals(QUEUE_MODE_IP) || queueMode.equals(QUEUE_MODE_DOMAIN) || queueMode.equals(QUEUE_MODE_HOST))) {
            LOG.error("Unknown partition mode : {} - forcing to byHost", (Object)queueMode);
            queueMode = QUEUE_MODE_HOST;
        }
        return queueMode;
    }

    public int getTotalSize() {
        return this.totalSize.get();
    }

    public int getQueueCount() {
        return this.queues.size();
    }

    public int getQueueCountMaxExceptions() {
        return this.queuesMaxExceptions.size();
    }

    public QueuingStatus addFetchItem(Text url, CrawlDatum datum) {
        FetchItem it = FetchItem.create(url, datum, this.queueMode);
        if (it != null) {
            return this.addFetchItem(it);
        }
        return QueuingStatus.ERROR_CREATE_FETCH_ITEM;
    }

    public synchronized QueuingStatus addFetchItem(FetchItem it) {
        if (this.maxExceptionsPerQueue != -1 && this.queuesMaxExceptions.contains(it.queueID)) {
            return QueuingStatus.ABOVE_EXCEPTION_THRESHOLD;
        }
        FetchItemQueue fiq = this.getFetchItemQueue(it.queueID);
        fiq.addFetchItem(it);
        this.totalSize.incrementAndGet();
        return QueuingStatus.SUCCESSFULLY_QUEUED;
    }

    public void finishFetchItem(FetchItem it) {
        this.finishFetchItem(it, false);
    }

    public void finishFetchItem(FetchItem it, boolean asap) {
        FetchItemQueue fiq = this.queues.get(it.queueID);
        if (fiq == null) {
            LOG.warn("Attempting to finish item from unknown queue: {}", (Object)it);
            return;
        }
        fiq.finishFetchItem(it, asap);
    }

    public synchronized FetchItemQueue getFetchItemQueue(String id) {
        FetchItemQueue fiq = this.queues.get(id);
        if (fiq == null) {
            fiq = new FetchItemQueue(this.conf, this.maxThreads, this.crawlDelay, this.minCrawlDelay);
            this.queues.put(id, fiq);
        }
        return fiq;
    }

    public synchronized FetchItem getFetchItem() {
        boolean keepExceptionState;
        Iterator<Map.Entry<String, FetchItemQueue>> it = this.lastIterator;
        if (it == null || !it.hasNext()) {
            it = this.queues.entrySet().iterator();
        }
        boolean bl = keepExceptionState = this.maxExceptionsPerQueue > -1 || this.exceptionsPerQueueDelay > 0L;
        while (it.hasNext()) {
            FetchItemQueue fiq = it.next().getValue();
            if (fiq.getQueueSize() == 0 && fiq.getInProgressSize() == 0) {
                if (!this.feederAlive) {
                    it.remove();
                    continue;
                }
                if (fiq.nextFetchTime.get() > System.currentTimeMillis()) continue;
                if (keepExceptionState && fiq.exceptionCounter.get() > 0) {
                    if (fiq.nextFetchTime.get() + this.exceptionsPerQueueClearAfter >= System.currentTimeMillis()) continue;
                    it.remove();
                    continue;
                }
                it.remove();
                continue;
            }
            FetchItem fit = fiq.getFetchItem();
            if (fit == null) continue;
            this.totalSize.decrementAndGet();
            this.lastIterator = it;
            return fit;
        }
        this.lastIterator = null;
        return null;
    }

    public boolean timelimitExceeded() {
        return this.timelimit != -1L && System.currentTimeMillis() >= this.timelimit;
    }

    public synchronized int checkTimelimit() {
        int count = 0;
        if (this.timelimitExceeded()) {
            count = this.emptyQueues();
            if (this.totalSize.get() != 0 && this.queues.size() == 0) {
                this.totalSize.set(0);
            }
        }
        return count;
    }

    public void setTimeoutReached() {
        this.timoutReached = true;
    }

    public synchronized int emptyQueues() {
        int count = 0;
        int queuesDropped = 0;
        for (String id : this.queues.keySet()) {
            FetchItemQueue fiq = this.queues.get(id);
            if (fiq.getQueueSize() == 0) continue;
            LOG.info("* queue: {} >> dropping!", (Object)id);
            int deleted = fiq.emptyQueue();
            this.totalSize.addAndGet(-deleted);
            count += deleted;
            ++queuesDropped;
        }
        LOG.info("Emptied all queues: {} queues with {} items", (Object)queuesDropped, (Object)count);
        return count;
    }

    public synchronized int checkExceptionThreshold(String queueid, int maxExceptions, long delay) {
        FetchItemQueue fiq = this.queues.get(queueid);
        if (fiq == null) {
            return 0;
        }
        int excCount = fiq.incrementExceptionCounter();
        if (maxExceptions != -1 && excCount >= maxExceptions) {
            return this.purgeAndBlockQueue(queueid, fiq, excCount);
        }
        long nexFetchTime = 0L;
        if (delay > 0L) {
            nexFetchTime = fiq.nextFetchTime.addAndGet(delay);
            LOG.info("* queue: {} >> delayed next fetch by {} ms", (Object)queueid, (Object)delay);
        } else if (this.exceptionsPerQueueDelay > 0L) {
            long exceptionDelay = this.exceptionsPerQueueDelay;
            if (excCount > 1) {
                exceptionDelay *= 2L << Math.min(excCount - 2, 31);
            }
            nexFetchTime = fiq.nextFetchTime.addAndGet(exceptionDelay);
            LOG.info("* queue: {} >> delayed next fetch by {} ms after {} exceptions in queue", new Object[]{queueid, exceptionDelay, excCount});
        }
        if (this.timelimit > 0L && nexFetchTime > this.timelimit) {
            LOG.info("* queue: {} >> purging queue because next fetch scheduled after fetcher timelimit", (Object)queueid);
            return this.purgeAndBlockQueue(queueid, fiq, excCount);
        }
        return 0;
    }

    private int purgeAndBlockQueue(String queueid, FetchItemQueue fiq, int excCount) {
        int deleted = fiq.emptyQueue();
        if (deleted > 0) {
            LOG.info("* queue: {} >> removed {} URLs from queue after {} exceptions occurred", new Object[]{queueid, deleted, excCount});
            this.totalSize.getAndAdd(-deleted);
        }
        if (this.feederAlive) {
            LOG.info("* queue: {} >> blocked after {} exceptions", (Object)queueid, (Object)excCount);
            this.queuesMaxExceptions.add(queueid);
        }
        return deleted;
    }

    public int checkExceptionThreshold(String queueid) {
        return this.checkExceptionThreshold(queueid, this.maxExceptionsPerQueue, -1L);
    }

    public boolean redirectIsQueuedRecently(Text redirUrl) {
        if (this.redirectDedupCache != null) {
            if (this.redirectDedupCache.getIfPresent((Object)redirUrl) != null) {
                return true;
            }
            this.redirectDedupCache.put((Object)redirUrl, (Object)Optional.absent());
        }
        return false;
    }

    public synchronized void dump() {
        for (String id : this.queues.keySet()) {
            FetchItemQueue fiq = this.queues.get(id);
            if (fiq.getQueueSize() == 0) continue;
            LOG.info("* queue: {}", (Object)id);
            fiq.dump();
        }
    }

    static enum QueuingStatus {
        SUCCESSFULLY_QUEUED,
        ERROR_CREATE_FETCH_ITEM,
        ABOVE_EXCEPTION_THRESHOLD,
        HIT_BY_TIMELIMIT,
        HIT_BY_TIMEOUT;

    }
}

