/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.Outlink;
import org.apache.nutch.parse.ParseStatus;
import org.apache.nutch.util.NutchConfiguration;

public final class ParseData
extends VersionedWritable {
    public static final String DIR_NAME = "parse_data";
    private static final byte VERSION = 5;
    private String title;
    private Outlink[] outlinks;
    private Metadata contentMeta;
    private Metadata parseMeta;
    private ParseStatus status;
    private byte version = (byte)5;

    public ParseData() {
        this.contentMeta = new Metadata();
        this.parseMeta = new Metadata();
    }

    public ParseData(ParseStatus status, String title, Outlink[] outlinks, Metadata contentMeta) {
        this(status, title, outlinks, contentMeta, new Metadata());
    }

    public ParseData(ParseStatus status, String title, Outlink[] outlinks, Metadata contentMeta, Metadata parseMeta) {
        this.status = status;
        this.title = title;
        this.outlinks = outlinks;
        this.contentMeta = contentMeta;
        this.parseMeta = parseMeta;
    }

    public ParseStatus getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    public Outlink[] getOutlinks() {
        return this.outlinks;
    }

    public Metadata getContentMeta() {
        return this.contentMeta;
    }

    public Metadata getParseMeta() {
        return this.parseMeta;
    }

    public void setParseMeta(Metadata parseMeta) {
        this.parseMeta = parseMeta;
    }

    public void setOutlinks(Outlink[] outlinks) {
        this.outlinks = outlinks;
    }

    public String getMeta(String name) {
        String value = this.parseMeta.get(name);
        if (value == null) {
            value = this.contentMeta.get(name);
        }
        return value;
    }

    public byte getVersion() {
        return this.version;
    }

    public final void readFields(DataInput in) throws IOException {
        this.version = in.readByte();
        if (this.version != 5) {
            throw new VersionMismatchException(5, this.version);
        }
        this.status = ParseStatus.read(in);
        this.title = Text.readString((DataInput)in);
        int numOutlinks = in.readInt();
        this.outlinks = new Outlink[numOutlinks];
        for (int i = 0; i < numOutlinks; ++i) {
            this.outlinks[i] = Outlink.read(in);
        }
        this.contentMeta.clear();
        this.contentMeta.readFields(in);
        this.parseMeta.clear();
        this.parseMeta.readFields(in);
    }

    public final void write(DataOutput out) throws IOException {
        out.writeByte(5);
        this.status.write(out);
        Text.writeString((DataOutput)out, (String)this.title);
        out.writeInt(this.outlinks.length);
        for (int i = 0; i < this.outlinks.length; ++i) {
            this.outlinks[i].write(out);
        }
        this.contentMeta.write(out);
        this.parseMeta.write(out);
    }

    public static ParseData read(DataInput in) throws IOException {
        ParseData parseText = new ParseData();
        parseText.readFields(in);
        return parseText;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParseData)) {
            return false;
        }
        ParseData other = (ParseData)((Object)o);
        return this.status.equals(other.status) && this.title.equals(other.title) && Arrays.equals(this.outlinks, other.outlinks) && this.contentMeta.equals(other.contentMeta) && this.parseMeta.equals(other.parseMeta);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Version: ").append(this.version).append("\n");
        buffer.append("Status: ").append(this.status).append("\n");
        buffer.append("Title: ").append(this.title).append("\n");
        if (this.outlinks != null) {
            buffer.append("Outlinks: ").append(this.outlinks.length).append("\n");
            for (int i = 0; i < this.outlinks.length; ++i) {
                buffer.append("  outlink: ").append(this.outlinks[i]).append("\n");
            }
        }
        buffer.append("Content Metadata:\n  ").append(this.contentMeta.toString("\n  ", " = ")).append("\n");
        buffer.append("Parse Metadata:\n  ").append(this.parseMeta.toString("\n  ", " = ")).append("\n");
        return buffer.toString();
    }

    public static void main(String[] argv) throws Exception {
        String usage = "ParseData (-local | -dfs <namenode:port>) recno segment";
        if (argv.length < 3) {
            System.out.println("usage:" + usage);
            return;
        }
        Options opts = new Options();
        Configuration conf = NutchConfiguration.create();
        GenericOptionsParser parser = new GenericOptionsParser(conf, opts, argv);
        String[] remainingArgs = parser.getRemainingArgs();
        try (FileSystem fs = FileSystem.get((Configuration)conf);){
            int recno = Integer.parseInt(remainingArgs[0]);
            String segment = remainingArgs[1];
            Path file = new Path(segment, DIR_NAME);
            System.out.println("Reading from file: " + String.valueOf(file));
            ArrayFile.Reader parses = new ArrayFile.Reader(fs, file.toString(), conf);
            ParseData parseDatum = new ParseData();
            parses.get((long)recno, (Writable)parseDatum);
            System.out.println("Retrieved " + recno + " from file " + String.valueOf(file));
            System.out.println((Object)parseDatum);
            parses.close();
        }
    }
}

