/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int EXPECTED_COMPRESSION_RATIO = 5;
    private static final int BUF_SIZE = 4096;

    public static final byte[] unzipBestEffort(byte[] in) {
        return GZIPUtils.unzipBestEffort(in, Integer.MAX_VALUE);
    }

    public static final byte[] unzipBestEffort(byte[] in, int sizeLimit) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
            GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(in));
            byte[] buf = new byte[4096];
            int written = 0;
            try {
                int size;
                while ((size = inStream.read(buf)) > 0) {
                    if (written + size > sizeLimit) {
                        outStream.write(buf, 0, sizeLimit - written);
                        break;
                    }
                    outStream.write(buf, 0, size);
                    written += size;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return outStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static final byte[] unzip(byte[] in) throws IOException {
        int size;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
        GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(in));
        byte[] buf = new byte[4096];
        while ((size = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, size);
        }
        outStream.close();
        return outStream.toByteArray();
    }

    public static final byte[] zip(byte[] in) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(in.length / 5);
            GZIPOutputStream outStream = new GZIPOutputStream(byteOut);
            try {
                outStream.write(in);
            }
            catch (Exception e) {
                LOG.error("Error writing outStream: ", (Throwable)e);
            }
            try {
                outStream.close();
            }
            catch (IOException e) {
                LOG.error("Error closing outStream: ", (Throwable)e);
            }
            return byteOut.toByteArray();
        }
        catch (IOException e) {
            LOG.error("Error: ", (Throwable)e);
            return null;
        }
    }
}

