/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;

public class NutchConfiguration {
    public static final String UUID_KEY = "nutch.conf.uuid";

    private NutchConfiguration() {
    }

    private static void setUUID(Configuration conf) {
        UUID uuid = UUID.randomUUID();
        conf.set(UUID_KEY, uuid.toString());
    }

    public static String getUUID(Configuration conf) {
        return conf.get(UUID_KEY);
    }

    public static Configuration create() {
        Configuration conf = new Configuration();
        NutchConfiguration.setUUID(conf);
        NutchConfiguration.addNutchResources(conf);
        return conf;
    }

    public static Configuration create(boolean addNutchResources, Properties nutchProperties) {
        Configuration conf = new Configuration();
        NutchConfiguration.setUUID(conf);
        if (addNutchResources) {
            NutchConfiguration.addNutchResources(conf);
        }
        for (Map.Entry<Object, Object> e : nutchProperties.entrySet()) {
            conf.set(e.getKey().toString(), e.getValue().toString());
        }
        return conf;
    }

    private static Configuration addNutchResources(Configuration conf) {
        conf.addResource("nutch-default.xml");
        conf.addResource("nutch-site.xml");
        return conf;
    }
}

