/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net.urlnormalizer.ajax;

import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxURLNormalizer
implements URLNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String AJAX_URL_PART = "#!";
    public static String ESCAPED_URL_PART = "_escaped_fragment_=";
    private Configuration conf;
    private Charset utf8 = Charset.forName("UTF-8");

    public String normalize(String urlString, String scope) throws MalformedURLException {
        LOG.info("{} // {}", (Object)scope, (Object)urlString);
        if (scope.equals("indexer") && urlString.contains(ESCAPED_URL_PART)) {
            return this.normalizeEscapedFragment(urlString);
        }
        if (urlString.contains(AJAX_URL_PART)) {
            LOG.info("{} // {}", (Object)scope, (Object)this.normalizeHashedFragment(urlString));
            return this.normalizeHashedFragment(urlString);
        }
        return urlString;
    }

    protected String normalizeHashedFragment(String urlString) throws MalformedURLException {
        URL u = new URL(urlString);
        int pos = urlString.indexOf(AJAX_URL_PART);
        StringBuilder sb = new StringBuilder(urlString.substring(0, pos));
        String escapedFragment = this.escape(urlString.substring(pos + AJAX_URL_PART.length()));
        if (u.getQuery() == null) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(ESCAPED_URL_PART);
        sb.append(escapedFragment);
        return sb.toString();
    }

    protected String normalizeEscapedFragment(String urlString) throws MalformedURLException {
        URL u = new URL(urlString);
        StringBuilder sb = new StringBuilder();
        sb.append(u.getProtocol());
        sb.append("://");
        sb.append(u.getHost());
        if (u.getPort() != -1) {
            sb.append(":");
            sb.append(u.getPort());
        }
        sb.append(u.getPath());
        String queryString = u.getQuery();
        int ampPos = queryString.indexOf("&");
        String keyValuePair = null;
        if (ampPos == -1) {
            keyValuePair = queryString;
            queryString = "";
        } else {
            keyValuePair = queryString.substring(ampPos + 1);
            queryString = queryString.replaceFirst("&" + keyValuePair, "");
        }
        keyValuePair = keyValuePair.replaceFirst(ESCAPED_URL_PART, "");
        String unescapedFragment = this.unescape(keyValuePair);
        if (queryString.length() > 0) {
            sb.append("?");
            sb.append(queryString);
        }
        sb.append("#!");
        sb.append(unescapedFragment);
        return sb.toString();
    }

    protected String unescape(String fragmentPart) {
        try {
            fragmentPart = URLDecoder.decode(fragmentPart, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fragmentPart;
    }

    protected String escape(String fragmentPart) {
        String hex = null;
        StringBuilder sb = new StringBuilder(fragmentPart.length());
        for (byte b : fragmentPart.getBytes(this.utf8)) {
            if (b < 33) {
                sb.append('%');
                hex = Integer.toHexString(b & 0xFF).toUpperCase();
                if (hex.length() % 2 != 0) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            if (b == 35) {
                sb.append("%23");
                continue;
            }
            if (b == 37) {
                sb.append("%25");
                continue;
            }
            if (b == 38) {
                sb.append("%26");
                continue;
            }
            if (b == 43) {
                sb.append("%2B");
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

