/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.similarity;

import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.AbstractScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;
import org.apache.nutch.scoring.similarity.SimilarityModel;
import org.apache.nutch.scoring.similarity.cosine.CosineSimilarity;

public class SimilarityScoringFilter
extends AbstractScoringFilter {
    private Configuration conf;
    private SimilarityModel similarityModel;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        switch (conf.get("scoring.similarity.model", "cosine")) {
            case "cosine": {
                this.similarityModel = new CosineSimilarity();
            }
        }
        this.similarityModel.setConf(conf);
    }

    public void passScoreAfterParsing(Text url, Content content, Parse parse) throws ScoringFilterException {
        float score = this.similarityModel.setURLScoreAfterParsing(url, content, parse);
        parse.getData().getContentMeta().set("nutch.crawl.score", "" + score);
    }

    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) throws ScoringFilterException {
        this.similarityModel.distributeScoreToOutlinks(fromUrl, parseData, targets, adjust, allCount);
        return adjust;
    }
}

