/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.nutch.protocol.httpclient.Http;
import org.apache.nutch.protocol.httpclient.HttpFormAuthConfigurer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFormAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<String, String> defaultLoginHeaders = new HashMap<String, String>();
    private HttpClient client;
    private HttpFormAuthConfigurer authConfigurer = new HttpFormAuthConfigurer();
    private String cookies;

    public HttpFormAuthentication(HttpFormAuthConfigurer authConfigurer, HttpClient client, Http http) {
        this.authConfigurer = authConfigurer;
        this.client = client;
        defaultLoginHeaders.put("Accept", http.getAccept());
        defaultLoginHeaders.put("Accept-Language", http.getAcceptLanguage());
        defaultLoginHeaders.put("User-Agent", http.getUserAgent());
    }

    public HttpFormAuthentication(String loginUrl, String loginForm, Map<String, String> loginPostData, Map<String, String> additionalPostHeaders, Set<String> removedFormFields) {
        this.authConfigurer.setLoginUrl(loginUrl);
        this.authConfigurer.setLoginFormId(loginForm);
        this.authConfigurer.setLoginPostData(loginPostData == null ? new HashMap() : loginPostData);
        this.authConfigurer.setAdditionalPostHeaders(additionalPostHeaders == null ? new HashMap() : additionalPostHeaders);
        this.authConfigurer.setRemovedFormFields(removedFormFields == null ? new HashSet() : removedFormFields);
        this.client = new HttpClient();
    }

    public void login() throws Exception {
        CookieHandler.setDefault(new CookieManager());
        String pageContent = this.httpGetPageContent(this.authConfigurer.getLoginUrl());
        List<NameValuePair> params = this.getLoginFormParams(pageContent);
        this.sendPost(this.authConfigurer.getLoginUrl(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPost(String url, List<NameValuePair> params) throws Exception {
        PostMethod post = null;
        try {
            post = this.authConfigurer.isLoginRedirect() ? new PostMethod(url){

                public boolean getFollowRedirects() {
                    return true;
                }
            } : new PostMethod(url);
            this.setLoginHeader(post);
            LOG.debug("FormAuth: set cookie policy");
            this.setCookieParams(this.authConfigurer, post.getParams());
            post.addParameters(params.toArray(new NameValuePair[0]));
            int rspCode = this.client.executeMethod((HttpMethod)post);
            if (LOG.isDebugEnabled()) {
                LOG.debug("rspCode: {}", (Object)rspCode);
                LOG.debug("\nSending 'POST' request to URL : {}", (Object)url);
                LOG.debug("Post parameters : {}", params);
                LOG.debug("Response Code : {}", (Object)rspCode);
                for (Header header : post.getRequestHeaders()) {
                    LOG.debug("Response headers : {}", (Object)header);
                }
            }
            String rst = IOUtils.toString((InputStream)post.getResponseBodyAsStream(), (Charset)StandardCharsets.UTF_8);
            LOG.debug("login post result: {}", (Object)rst);
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    private void setCookieParams(HttpFormAuthConfigurer formConfigurer, HttpMethodParams params) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String policy;
        Object p;
        if (formConfigurer.getCookiePolicy() != null && null != (p = FieldUtils.readDeclaredStaticField(CookiePolicy.class, (String)(policy = formConfigurer.getCookiePolicy())))) {
            LOG.debug("reflection of cookie value: {}", p);
            params.setParameter("http.protocol.cookie-policy", p);
        }
    }

    private void setLoginHeader(PostMethod post) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(defaultLoginHeaders);
        headers.putAll(this.authConfigurer.getAdditionalPostHeaders());
        for (Map.Entry entry : headers.entrySet()) {
            post.addRequestHeader((String)entry.getKey(), (String)entry.getValue());
        }
        post.addRequestHeader("Cookie", this.getCookies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpGetPageContent(String url) throws IOException {
        GetMethod get = new GetMethod(url);
        try {
            String rst;
            for (Map.Entry<String, String> entry : this.authConfigurer.getAdditionalPostHeaders().entrySet()) {
                get.addRequestHeader(entry.getKey(), entry.getValue());
            }
            this.client.executeMethod((HttpMethod)get);
            Header cookieHeader = get.getResponseHeader("Set-Cookie");
            if (cookieHeader != null) {
                this.setCookies(cookieHeader.getValue());
            }
            String string = rst = IOUtils.toString((InputStream)get.getResponseBodyAsStream(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    private List<NameValuePair> getLoginFormParams(String pageContent) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        Document doc = Jsoup.parse((String)pageContent);
        Element loginform = doc.getElementById(this.authConfigurer.getLoginFormId());
        if (loginform == null) {
            LOG.debug("No form element found with 'id' = {}, trying 'name'.", (Object)this.authConfigurer.getLoginFormId());
            loginform = doc.select("form[name=" + this.authConfigurer.getLoginFormId() + "]").first();
            if (loginform == null) {
                LOG.debug("No form element found with 'name' = {}", (Object)this.authConfigurer.getLoginFormId());
                throw new IllegalArgumentException("No form exists: " + this.authConfigurer.getLoginFormId());
            }
        }
        Elements inputElements = loginform.getElementsByTag("input");
        for (Element inputElement : inputElements) {
            String key = inputElement.attr("name");
            String value = inputElement.attr("value");
            if (this.authConfigurer.getLoginPostData().containsKey(key) || this.authConfigurer.getRemovedFormFields().contains(key)) continue;
            params.add(new NameValuePair(key, value));
        }
        for (Map.Entry<String, String> entry : this.authConfigurer.getLoginPostData().entrySet()) {
            params.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        return params;
    }

    public String getCookies() {
        return this.cookies;
    }

    public void setCookies(String cookies) {
        this.cookies = cookies;
    }

    public boolean isRedirect() {
        return this.authConfigurer.isLoginRedirect();
    }

    public void setRedirect(boolean redirect) {
        this.authConfigurer.setLoginRedirect(redirect);
    }

    static {
        defaultLoginHeaders.put("User-Agent", "Mozilla/5.0");
        defaultLoginHeaders.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        defaultLoginHeaders.put("Accept-Language", "en-US,en;q=0.5");
        defaultLoginHeaders.put("Connection", "keep-alive");
        defaultLoginHeaders.put("Content-Type", "application/x-www-form-urlencoded");
    }
}

