/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import org.opensearch.cli.SuppressForbidden;

public abstract class Terminal {
    private static final PrintWriter ERROR_WRITER = Terminal.newErrorWriter();
    public static final Terminal DEFAULT = ConsoleTerminal.isSupported() ? new ConsoleTerminal() : new SystemTerminal();
    private Verbosity verbosity = Verbosity.NORMAL;
    private final String lineSeparator;

    @SuppressForbidden(reason="Writer for System.err")
    private static PrintWriter newErrorWriter() {
        return new PrintWriter(System.err);
    }

    protected Terminal(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public abstract String readText(String var1);

    public abstract char[] readSecret(String var1);

    public char[] readSecret(String prompt, int maxLength) {
        char[] result = this.readSecret(prompt);
        if (result.length > maxLength) {
            Arrays.fill(result, '\u0000');
            throw new IllegalStateException("Secret exceeded maximum length of " + maxLength);
        }
        return result;
    }

    public abstract PrintWriter getWriter();

    public PrintWriter getErrorWriter() {
        return ERROR_WRITER;
    }

    public final void println(String msg) {
        this.println(Verbosity.NORMAL, msg);
    }

    public final void println(Verbosity verbosity, String msg) {
        this.print(verbosity, msg + this.lineSeparator);
    }

    public final void print(Verbosity verbosity, String msg) {
        this.print(verbosity, msg, false);
    }

    private void print(Verbosity verbosity, String msg, boolean isError) {
        if (this.isPrintable(verbosity)) {
            PrintWriter writer = isError ? this.getErrorWriter() : this.getWriter();
            writer.print(msg);
            writer.flush();
        }
    }

    public final void errorPrint(Verbosity verbosity, String msg) {
        this.print(verbosity, msg, true);
    }

    public final void errorPrintln(String msg) {
        this.errorPrintln(Verbosity.NORMAL, msg);
    }

    public final void errorPrintln(Verbosity verbosity, String msg) {
        this.errorPrint(verbosity, msg + this.lineSeparator);
    }

    public final boolean isPrintable(Verbosity verbosity) {
        return this.verbosity.ordinal() >= verbosity.ordinal();
    }

    public final boolean promptYesNo(String prompt, boolean defaultYes) {
        boolean answerYes;
        String answerPrompt;
        String string = answerPrompt = defaultYes ? " [Y/n]" : " [y/N]";
        while (true) {
            String answer;
            if ((answer = this.readText(prompt + answerPrompt)) == null || answer.isEmpty()) {
                return defaultYes;
            }
            answerYes = (answer = answer.toLowerCase(Locale.ROOT)).equals("y");
            if (answerYes || answer.equals("n")) break;
            this.errorPrintln("Did not understand answer '" + answer + "'");
        }
        return answerYes;
    }

    public static char[] readLineToCharArray(Reader reader, int maxLength) {
        char[] buf = new char[maxLength + 2];
        try {
            char nextChar;
            int next;
            int len = 0;
            while ((next = reader.read()) != -1 && (nextChar = (char)next) != '\n') {
                if (len < buf.length) {
                    buf[len] = nextChar;
                }
                ++len;
            }
            if (len > 0 && len < buf.length && buf[len - 1] == '\r') {
                --len;
            }
            if (len > maxLength) {
                Arrays.fill(buf, '\u0000');
                throw new RuntimeException("Input exceeded maximum length of " + maxLength);
            }
            char[] shortResult = Arrays.copyOf(buf, len);
            Arrays.fill(buf, '\u0000');
            return shortResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        this.getWriter().flush();
        this.getErrorWriter().flush();
    }

    static class SystemTerminal
    extends Terminal {
        private static final PrintWriter WRITER = SystemTerminal.newWriter();
        private BufferedReader reader;

        SystemTerminal() {
            super(System.lineSeparator());
        }

        @SuppressForbidden(reason="Writer for System.out")
        private static PrintWriter newWriter() {
            return new PrintWriter(System.out);
        }

        BufferedReader getReader() {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            }
            return this.reader;
        }

        @Override
        public PrintWriter getWriter() {
            return WRITER;
        }

        @Override
        public String readText(String text) {
            this.getErrorWriter().print(text);
            try {
                String line = this.getReader().readLine();
                if (line == null) {
                    throw new IllegalStateException("unable to read from standard input; is standard input open and a tty attached?");
                }
                return line;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public char[] readSecret(String text) {
            return this.readText(text).toCharArray();
        }

        @Override
        public char[] readSecret(String text, int maxLength) {
            this.getErrorWriter().println(text);
            return SystemTerminal.readLineToCharArray(this.getReader(), maxLength);
        }
    }

    private static class ConsoleTerminal
    extends Terminal {
        private static final Console CONSOLE = System.console();

        ConsoleTerminal() {
            super(System.lineSeparator());
        }

        static boolean isSupported() {
            return CONSOLE != null;
        }

        @Override
        public PrintWriter getWriter() {
            return CONSOLE.writer();
        }

        @Override
        public String readText(String prompt) {
            return CONSOLE.readLine("%s", prompt);
        }

        @Override
        public char[] readSecret(String prompt) {
            return CONSOLE.readPassword("%s", prompt);
        }
    }

    public static enum Verbosity {
        SILENT,
        NORMAL,
        VERBOSE;

    }
}

