/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.PrintStream;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.resource.ResourceContainer;
import org.archive.util.StreamCopy;

public abstract class AbstractResource
implements Resource {
    protected ResourceContainer container;
    protected MetaData metaData;

    public AbstractResource(MetaData metaData, ResourceContainer container) {
        this.container = container;
        this.metaData = metaData;
    }

    @Override
    public ResourceContainer getContainer() {
        return this.container;
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    public static void dump(PrintStream out, Resource resource) throws IOException {
        MetaData m = resource.getMetaData();
        out.println("Headers Before");
        out.print(m.toString());
        out.println("Resource Follows:\n===================");
        StreamCopy.copy(resource.getInputStream(), out);
        out.println("[\n]Headers After");
        out.print(m.toString());
    }

    public static void dumpShort(PrintStream out, Resource resource) throws IOException {
        MetaData m = resource.getMetaData();
        long bytes = StreamCopy.copy(resource.getInputStream(), ByteStreams.nullOutputStream());
        out.println("Resource Was:" + bytes + " Long");
        out.println("[\n]Headers After");
        out.print(m.toString());
    }
}

