/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.css;

import com.gargoylesoftware.htmlunit.css.ComputedCssStyleDeclaration;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlCanvas;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;

public final class CssPixelValueConverter {
    private static final Pattern TO_FLOAT_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+)?).*");

    private CssPixelValueConverter() {
    }

    public static int pixelValue(DomElement element, CssValue value) {
        return CssPixelValueConverter.pixelValue(element, value, false);
    }

    public static String pixelString(DomElement element, CssValue value) {
        ComputedCssStyleDeclaration style = element.getPage().getEnclosingWindow().getComputedStyle(element, null);
        String s = value.get(style);
        if (s.endsWith("px")) {
            return s;
        }
        return CssPixelValueConverter.pixelValue(element, value) + "px";
    }

    public static int pixelValue(String value) {
        float i = NumberUtils.toFloat((String)TO_FLOAT_PATTERN.matcher(value).replaceAll("$1"), (float)0.0f);
        if (value.length() < 2) {
            return Math.round(i);
        }
        if (value.endsWith("px")) {
            return Math.round(i);
        }
        if (value.endsWith("em")) {
            i *= 16.0f;
        } else if (value.endsWith("%")) {
            i = i * 16.0f / 100.0f;
        } else if (value.endsWith("ex")) {
            i *= 10.0f;
        } else if (value.endsWith("in")) {
            i *= 150.0f;
        } else if (value.endsWith("cm")) {
            i *= 50.0f;
        } else if (value.endsWith("mm")) {
            i *= 5.0f;
        } else if (value.endsWith("pt")) {
            i *= 2.0f;
        } else if (value.endsWith("pc")) {
            i *= 24.0f;
        }
        return Math.round(i);
    }

    private static int pixelValue(DomElement element, CssValue value, boolean percentMode) {
        ComputedCssStyleDeclaration style = element.getPage().getEnclosingWindow().getComputedStyle(element, null);
        String s = value.get(style);
        if (s.endsWith("%") || s.isEmpty() && element instanceof HtmlHtml) {
            float i = NumberUtils.toFloat((String)TO_FLOAT_PATTERN.matcher(s).replaceAll("$1"), (float)100.0f);
            DomNode parent = element.getParentNode();
            int absoluteValue = parent instanceof DomElement ? CssPixelValueConverter.pixelValue((DomElement)parent, value, true) : value.getWindowDefaultValue();
            return Math.round(i / 100.0f * (float)absoluteValue);
        }
        if ("auto".equals(s)) {
            return value.getDefaultValue();
        }
        if (s.isEmpty()) {
            if (element instanceof HtmlCanvas) {
                return value.getWindowDefaultValue();
            }
            if (percentMode) {
                DomNode parent = element.getParentNode();
                if (parent == null || parent instanceof HtmlHtml) {
                    return value.getWindowDefaultValue();
                }
                return CssPixelValueConverter.pixelValue((DomElement)parent, value, true);
            }
            return 0;
        }
        return CssPixelValueConverter.pixelValue(s);
    }

    public static abstract class CssValue {
        private final int defaultValue_;
        private final int windowDefaultValue_;

        public CssValue(int defaultValue, int windowDefaultValue) {
            this.defaultValue_ = defaultValue;
            this.windowDefaultValue_ = windowDefaultValue;
        }

        public int getDefaultValue() {
            return this.defaultValue_;
        }

        public int getWindowDefaultValue() {
            return this.windowDefaultValue_;
        }

        public abstract String get(ComputedCssStyleDeclaration var1);
    }
}

