/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.graph;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.graph.Node;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatherNodesStream
extends TupleStream
implements Expressible {
    private String zkHost;
    private String collection;
    private StreamContext streamContext;
    private Map<String, String> queryParams;
    private String traverseFrom;
    private String traverseTo;
    private String gather;
    private boolean trackTraversal;
    private boolean useDefaultTraversal;
    private TupleStream tupleStream;
    private Set<Traversal.Scatter> scatter;
    private Iterator<Tuple> out;
    private Traversal traversal;
    private List<Metric> metrics;
    private int maxDocFreq;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX", Locale.ENGLISH);
    private Set<String> windowSet;
    private int window = Integer.MIN_VALUE;
    private int lag = 1;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public GatherNodesStream(String zkHost, String collection, TupleStream tupleStream, String traverseFrom, String traverseTo, String gather, Map queryParams, List<Metric> metrics, boolean trackTraversal, Set<Traversal.Scatter> scatter, int maxDocFreq) {
        this.init(zkHost, collection, tupleStream, traverseFrom, traverseTo, gather, queryParams, metrics, trackTraversal, scatter, maxDocFreq, Integer.MIN_VALUE, 1);
    }

    public GatherNodesStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String[] fields;
        String edge;
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        HashSet<Traversal.Scatter> scatter = new HashSet<Traversal.Scatter>();
        StreamExpressionNamedParameter scatterExpression = factory.getNamedOperand(expression, "scatter");
        if (scatterExpression == null) {
            scatter.add(Traversal.Scatter.LEAVES);
        } else {
            String[] sArray;
            String s = ((StreamExpressionValue)scatterExpression.getParameter()).getValue();
            for (String sv : sArray = s.split(",")) {
                sv = sv.trim();
                if (Traversal.Scatter.BRANCHES.toString().equalsIgnoreCase(sv)) {
                    scatter.add(Traversal.Scatter.BRANCHES);
                    continue;
                }
                if (!Traversal.Scatter.LEAVES.toString().equalsIgnoreCase(sv)) continue;
                scatter.add(Traversal.Scatter.LEAVES);
            }
        }
        String gather = null;
        StreamExpressionNamedParameter gatherExpression = factory.getNamedOperand(expression, "gather");
        if (gatherExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - from param is required", expression));
        }
        gather = ((StreamExpressionValue)gatherExpression.getParameter()).getValue();
        String traverseFrom = null;
        String traverseTo = null;
        StreamExpressionNamedParameter edgeExpression = factory.getNamedOperand(expression, "walk");
        TupleStream stream = null;
        if (edgeExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - walk param is required", expression));
        }
        if (streamExpressions.size() > 0) {
            stream = factory.constructStream(streamExpressions.get(0));
            edge = ((StreamExpressionValue)edgeExpression.getParameter()).getValue();
            fields = edge.split("->");
            if (fields.length != 2) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - walk param separated by an -> and must contain two fields", expression));
            }
            traverseFrom = fields[0].trim();
            traverseTo = fields[1].trim();
        } else {
            edge = ((StreamExpressionValue)edgeExpression.getParameter()).getValue();
            fields = edge.split("->");
            if (fields.length != 2) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - walk param separated by an -> and must contain two fields", expression));
            }
            String[] rootNodes = fields[0].split(",");
            ArrayList<String> l = new ArrayList<String>();
            for (String n : rootNodes) {
                l.add(n.trim());
            }
            stream = new NodeStream(l);
            traverseFrom = "node";
            traverseTo = fields[1].trim();
        }
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (int idx = 0; idx < metricExpressions.size(); ++idx) {
            metrics.add(factory.constructMetric(metricExpressions.get(idx)));
        }
        boolean trackTraversal = false;
        StreamExpressionNamedParameter trackExpression = factory.getNamedOperand(expression, "trackTraversal");
        if (trackExpression != null) {
            trackTraversal = Boolean.parseBoolean(((StreamExpressionValue)trackExpression.getParameter()).getValue());
        } else {
            this.useDefaultTraversal = true;
        }
        StreamExpressionNamedParameter windowExpression = factory.getNamedOperand(expression, "window");
        int timeWindow = Integer.MIN_VALUE;
        if (windowExpression != null) {
            timeWindow = Integer.parseInt(((StreamExpressionValue)windowExpression.getParameter()).getValue());
        }
        StreamExpressionNamedParameter lagExpression = factory.getNamedOperand(expression, "lag");
        int timeLag = 1;
        if (lagExpression != null) {
            timeLag = Integer.parseInt(((StreamExpressionValue)lagExpression.getParameter()).getValue());
        }
        StreamExpressionNamedParameter docFreqExpression = factory.getNamedOperand(expression, "maxDocFreq");
        int docFreq = -1;
        if (docFreqExpression != null) {
            docFreq = Integer.parseInt(((StreamExpressionValue)docFreqExpression.getParameter()).getValue());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("gather") || namedParam.getName().equals("walk") || namedParam.getName().equals("scatter") || namedParam.getName().equals("maxDocFreq") || namedParam.getName().equals("trackTraversal") || namedParam.getName().equals("window") || namedParam.getName().equals("lag")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(zkHost, collectionName, stream, traverseFrom, traverseTo, gather, params, metrics, trackTraversal, scatter, docFreq, timeWindow, timeLag);
    }

    private void init(String zkHost, String collection, TupleStream tupleStream, String traverseFrom, String traverseTo, String gather, Map queryParams, List<Metric> metrics, boolean trackTraversal, Set<Traversal.Scatter> scatter, int maxDocFreq, int window, int lag) {
        this.zkHost = zkHost;
        this.collection = collection;
        this.tupleStream = tupleStream;
        this.traverseFrom = traverseFrom;
        this.traverseTo = traverseTo;
        this.gather = gather;
        this.queryParams = queryParams;
        this.metrics = metrics;
        this.trackTraversal = trackTraversal;
        this.scatter = scatter;
        this.maxDocFreq = maxDocFreq;
        this.window = window;
        if (window > Integer.MIN_VALUE) {
            this.windowSet = new HashSet<String>();
        }
        this.lag = lag;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        if (includeStreams && !(this.tupleStream instanceof NodeStream)) {
            if (!(this.tupleStream instanceof Expressible)) throw new IOException("This GatherNodesStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.tupleStream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        Set<Map.Entry<String, String>> entries = this.queryParams.entrySet();
        for (Map.Entry<String, String> param : entries) {
            String value = param.getValue().toString();
            value = value.replace("\"", "\\\"");
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey().toString(), value));
        }
        if (this.metrics != null) {
            for (Metric metric : this.metrics) {
                expression.addParameter(metric.toExpression(factory));
            }
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        expression.addParameter(new StreamExpressionNamedParameter("gather", this.zkHost));
        if (this.maxDocFreq > -1) {
            expression.addParameter(new StreamExpressionNamedParameter("maxDocFreq", Integer.toString(this.maxDocFreq)));
        }
        if (this.tupleStream instanceof NodeStream) {
            NodeStream nodeStream = (NodeStream)this.tupleStream;
            expression.addParameter(new StreamExpressionNamedParameter("walk", nodeStream.toString() + "->" + this.traverseTo));
        } else {
            expression.addParameter(new StreamExpressionNamedParameter("walk", this.traverseFrom + "->" + this.traverseTo));
        }
        expression.addParameter(new StreamExpressionNamedParameter("trackTraversal", Boolean.toString(this.trackTraversal)));
        StringBuilder buf = new StringBuilder();
        for (Traversal.Scatter sc : this.scatter) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(sc.toString());
        }
        expression.addParameter(new StreamExpressionNamedParameter("scatter", buf.toString()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("graph-source");
        explanation.setExpression(this.toExpression(factory).toString());
        explanation.addChild(this.tupleStream.toExplanation(factory));
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName("solr (graph)");
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        child.setExpression(this.queryParams.entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(",")));
        explanation.addChild(child);
        if (null != this.metrics) {
            for (Metric metric : this.metrics) {
                explanation.addHelper(metric.toExplanation(factory));
            }
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.traversal = (Traversal)context.get("traversal");
        if (this.traversal == null) {
            StreamContext localContext = new StreamContext();
            localContext.numWorkers = context.numWorkers;
            localContext.workerID = context.workerID;
            localContext.setSolrClientCache(context.getSolrClientCache());
            localContext.setStreamFactory(context.getStreamFactory());
            for (Object key : context.getEntries().keySet()) {
                localContext.put(key, context.get(key));
            }
            this.traversal = new Traversal();
            localContext.put("traversal", this.traversal);
            this.tupleStream.setStreamContext(localContext);
            this.streamContext = localContext;
        } else {
            this.tupleStream.setStreamContext(context);
            this.streamContext = context;
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tupleStream.open();
    }

    private String[] getTenSecondWindow(int size, int lag, String start) {
        try {
            String[] window = new String[size];
            Date date = this.dateFormat.parse(start);
            Instant instant = date.toInstant();
            for (int i = 0; i < size; ++i) {
                Instant windowInstant = instant.minus(10 * (i + lag), ChronoUnit.SECONDS);
                String windowString = windowInstant.toString();
                window[i] = windowString = windowString.substring(0, 18) + "0Z";
            }
            return window;
        }
        catch (ParseException e) {
            log.warn("Unparseable date:{}", (Object)String.valueOf(start));
            return new String[0];
        }
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        if (this.out == null) {
            ArrayList<String> joinBatch = new ArrayList<String>();
            ArrayList<Future<List<Tuple>>> futures = new ArrayList<Future<List<Tuple>>>();
            HashMap<String, Node> level = new HashMap<String, Node>();
            ExecutorService threadPool = null;
            try {
                threadPool = ExecutorUtil.newMDCAwareFixedThreadPool(4, new SolrNamedThreadFactory("GatherNodesStream"));
                HashMap<String, Node> roots = new HashMap<String, Node>();
                while (true) {
                    Tuple tuple = this.tupleStream.read();
                    if (tuple.EOF) {
                        if (joinBatch.size() <= 0) break;
                        JoinRunner joinRunner = new JoinRunner(joinBatch);
                        Future<List<Tuple>> future = threadPool.submit(joinRunner);
                        futures.add(future);
                        break;
                    }
                    String string = tuple.getString(this.traverseFrom);
                    if (this.traversal.getDepth() == 0) {
                        String key = this.collection + "." + string;
                        if (roots.containsKey(key)) continue;
                        String[] node = new Node(string, this.trackTraversal);
                        if (this.metrics != null) {
                            ArrayList<Metric> _metrics = new ArrayList<Metric>();
                            for (Metric metric : this.metrics) {
                                _metrics.add(metric.newInstance());
                            }
                            node.setMetrics(_metrics);
                        }
                        roots.put(key, (Node)node);
                    }
                    if (this.windowSet == null || this.lag == 1 && !this.windowSet.contains(String.valueOf(string))) {
                        joinBatch.add(string);
                    }
                    if (this.window > Integer.MIN_VALUE && string != null) {
                        String[] timeWindow;
                        this.windowSet.add(string);
                        for (String windowString : timeWindow = this.getTenSecondWindow(this.window, this.lag, string)) {
                            if (!this.windowSet.contains(windowString)) {
                                joinBatch.add(windowString);
                            }
                            this.windowSet.add(windowString);
                        }
                    }
                    if (joinBatch.size() < 400) continue;
                    JoinRunner joinRunner = new JoinRunner(joinBatch);
                    Future<List<Tuple>> future = threadPool.submit(joinRunner);
                    futures.add(future);
                    joinBatch = new ArrayList();
                }
                if (this.traversal.getDepth() == 0) {
                    this.traversal.addLevel(roots, this.collection, this.traverseFrom);
                }
                this.traversal.setScatter(this.scatter);
                if (this.useDefaultTraversal) {
                    this.trackTraversal = this.traversal.getTrackTraversal();
                } else {
                    this.traversal.setTrackTraversal(this.trackTraversal);
                }
                for (Future future : futures) {
                    List tuples = (List)future.get();
                    for (Tuple tuple : tuples) {
                        String _traverseTo = tuple.getString(this.traverseTo);
                        String _gather = tuple.getString(this.gather);
                        String key = this.collection + "." + _gather;
                        if (this.traversal.visited(key, _traverseTo, tuple)) continue;
                        Node node = (Node)level.get(key);
                        if (node != null) {
                            node.add(this.traversal.getDepth() - 1 + "^" + _traverseTo, tuple);
                            continue;
                        }
                        node = new Node(_gather, this.trackTraversal);
                        if (this.metrics != null) {
                            ArrayList<Metric> _metrics = new ArrayList<Metric>();
                            for (Metric metric : this.metrics) {
                                _metrics.add(metric.newInstance());
                            }
                            node.setMetrics(_metrics);
                        }
                        node.add(this.traversal.getDepth() - 1 + "^" + _traverseTo, tuple);
                        level.put(key, node);
                    }
                }
                this.traversal.addLevel(level, this.collection, this.gather);
                this.out = this.traversal.iterator();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                threadPool.shutdown();
            }
        }
        if (this.out.hasNext()) {
            return this.out.next();
        }
        return Tuple.EOF();
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    static class NodeStream
    extends TupleStream {
        private List<String> ids;
        private Iterator<String> it;

        public NodeStream(List<String> ids) {
            this.ids = ids;
        }

        @Override
        public void open() {
            this.it = this.ids.iterator();
        }

        @Override
        public void close() {
        }

        @Override
        public StreamComparator getStreamSort() {
            return null;
        }

        @Override
        public List<TupleStream> children() {
            return new ArrayList<TupleStream>();
        }

        @Override
        public void setStreamContext(StreamContext context) {
        }

        @Override
        public Tuple read() {
            if (this.it.hasNext()) {
                return new Tuple("node", this.it.next());
            }
            return Tuple.EOF();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean comma = false;
            for (String s : this.ids) {
                if (comma) {
                    builder.append(",");
                }
                builder.append(s);
                comma = true;
            }
            return builder.toString();
        }

        @Override
        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("non-expressible").withImplementingClass(this.getClass().getName()).withExpressionType("stream-source").withExpression("non-expressible");
        }
    }

    private class JoinRunner
    implements Callable<List<Tuple>> {
        private List<String> nodes;
        private List<Tuple> edges = new ArrayList<Tuple>();

        public JoinRunner(List<String> nodes) {
            this.nodes = nodes;
        }

        @Override
        public List<Tuple> call() {
            HashSet<String> flSet = new HashSet<String>();
            flSet.add(GatherNodesStream.this.gather);
            flSet.add(GatherNodesStream.this.traverseTo);
            if (GatherNodesStream.this.metrics != null) {
                for (Metric metric : GatherNodesStream.this.metrics) {
                    for (String column : metric.getColumns()) {
                        flSet.add(column);
                    }
                }
            }
            if (GatherNodesStream.this.queryParams.containsKey("fl")) {
                String flString = (String)GatherNodesStream.this.queryParams.get("fl");
                String[] flArray = flString.split(",");
                for (String f : flArray) {
                    flSet.add(f.trim());
                }
            }
            Iterator it = flSet.iterator();
            StringBuilder buf = new StringBuilder();
            while (it.hasNext()) {
                buf.append((String)it.next());
                if (!it.hasNext()) continue;
                buf.append(",");
            }
            ModifiableSolrParams joinSParams = new ModifiableSolrParams();
            GatherNodesStream.this.queryParams.forEach((x$0, xva$1) -> joinSParams.add((String)x$0, (String)xva$1));
            joinSParams.set("fl", buf.toString());
            joinSParams.set("qt", "/export");
            joinSParams.set("sort", GatherNodesStream.this.gather + " asc," + GatherNodesStream.this.traverseTo + " asc");
            StringBuffer nodeQuery = new StringBuffer();
            boolean comma = false;
            for (String node : this.nodes) {
                if (comma) {
                    nodeQuery.append(",");
                }
                nodeQuery.append(node);
                comma = true;
            }
            if (GatherNodesStream.this.maxDocFreq > -1) {
                String docFreqParam = " maxDocFreq=" + GatherNodesStream.this.maxDocFreq;
                joinSParams.set("q", "{!graphTerms f=" + GatherNodesStream.this.traverseTo + docFreqParam + "}" + nodeQuery.toString());
            } else {
                joinSParams.set("q", "{!terms f=" + GatherNodesStream.this.traverseTo + "}" + nodeQuery.toString());
            }
            TupleStream stream = null;
            try {
                stream = new UniqueStream(new CloudSolrStream(GatherNodesStream.this.zkHost, GatherNodesStream.this.collection, joinSParams), new MultipleFieldEqualitor(new FieldEqualitor(GatherNodesStream.this.gather), new FieldEqualitor(GatherNodesStream.this.traverseTo)));
                stream.setStreamContext(GatherNodesStream.this.streamContext);
                stream.open();
                while (true) {
                    Tuple tuple = stream.read();
                    if (tuple.EOF) {
                        break;
                    }
                    this.edges.add(tuple);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception ce) {
                    throw new RuntimeException(ce);
                }
            }
            return this.edges;
        }
    }
}

