/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.security.FastSaslClientFactory;
import org.apache.hadoop.security.FastSaslServerFactory;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslOutputStream;

@InterfaceAudience.Private
class SaslParticipant {
    private static final String SERVER_NAME = "0";
    private static final String PROTOCOL = "hdfs";
    private static final String MECHANISM = "DIGEST-MD5";
    private final SaslServer saslServer;
    private final SaslClient saslClient;
    private static SaslServerFactory saslServerFactory;
    private static SaslClientFactory saslClientFactory;

    private static void initializeSaslServerFactory() {
        if (saslServerFactory == null) {
            saslServerFactory = new FastSaslServerFactory(null);
        }
    }

    private static void initializeSaslClientFactory() {
        if (saslClientFactory == null) {
            saslClientFactory = new FastSaslClientFactory(null);
        }
    }

    public static SaslParticipant createServerSaslParticipant(Map<String, String> saslProps, CallbackHandler callbackHandler) throws SaslException {
        SaslParticipant.initializeSaslServerFactory();
        return new SaslParticipant(saslServerFactory.createSaslServer(MECHANISM, PROTOCOL, SERVER_NAME, saslProps, callbackHandler));
    }

    public static SaslParticipant createClientSaslParticipant(String userName, Map<String, String> saslProps, CallbackHandler callbackHandler) throws SaslException {
        SaslParticipant.initializeSaslClientFactory();
        return new SaslParticipant(saslClientFactory.createSaslClient(new String[]{MECHANISM}, userName, PROTOCOL, SERVER_NAME, saslProps, callbackHandler));
    }

    private SaslParticipant(SaslServer saslServer) {
        this.saslServer = saslServer;
        this.saslClient = null;
    }

    private SaslParticipant(SaslClient saslClient) {
        this.saslServer = null;
        this.saslClient = saslClient;
    }

    public byte[] evaluateChallengeOrResponse(byte[] challengeOrResponse) throws SaslException {
        if (this.saslClient != null) {
            return this.saslClient.evaluateChallenge(challengeOrResponse);
        }
        return this.saslServer.evaluateResponse(challengeOrResponse);
    }

    public String getNegotiatedQop() {
        if (this.saslClient != null) {
            return (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        }
        return (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
    }

    public boolean isNegotiatedQopPrivacy() {
        String qop = this.getNegotiatedQop();
        return qop != null && "auth-conf".equalsIgnoreCase(qop);
    }

    public byte[] wrap(byte[] bytes, int off, int len) throws SaslException {
        if (this.saslClient != null) {
            return this.saslClient.wrap(bytes, off, len);
        }
        return this.saslServer.wrap(bytes, off, len);
    }

    public byte[] unwrap(byte[] bytes, int off, int len) throws SaslException {
        if (this.saslClient != null) {
            return this.saslClient.unwrap(bytes, off, len);
        }
        return this.saslServer.unwrap(bytes, off, len);
    }

    public boolean isComplete() {
        if (this.saslClient != null) {
            return this.saslClient.isComplete();
        }
        return this.saslServer.isComplete();
    }

    public IOStreamPair createStreamPair(DataOutputStream out, DataInputStream in) {
        if (this.saslClient != null) {
            return new IOStreamPair((InputStream)new SaslInputStream((InputStream)in, this.saslClient), (OutputStream)new SaslOutputStream((OutputStream)out, this.saslClient));
        }
        return new IOStreamPair((InputStream)new SaslInputStream((InputStream)in, this.saslServer), (OutputStream)new SaslOutputStream((OutputStream)out, this.saslServer));
    }
}

