/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.jexl3.scripting.JexlScriptEngineFactory;

public class Main {
    public static void main(String[] args) throws Exception {
        try (BufferedReader in = args.length == 1 ? Main.read(Paths.get(args[0], new String[0])) : Main.read(null);
             PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()), true);){
            Main.run(in, out, args);
        }
    }

    static void run(BufferedReader in, PrintWriter out, Object[] args) throws Exception {
        JexlScriptEngineFactory fac = new JexlScriptEngineFactory();
        ScriptEngine engine = fac.getScriptEngine();
        if (args != null && args.length > 0) {
            engine.put("args", args);
            Object value = engine.eval(in);
            out.println(">>: " + value);
        } else {
            String line;
            out.print("> ");
            while (null != (line = in.readLine()) && !"//q!".equals(line)) {
                try {
                    Object value = engine.eval(line);
                    out.println(">> " + value);
                }
                catch (ScriptException e) {
                    out.println("!!>" + e.getLocalizedMessage());
                }
                out.print("> ");
            }
        }
    }

    static BufferedReader read(Path path) throws IOException {
        return new BufferedReader(new InputStreamReader(path == null ? System.in : Files.newInputStream(path, new OpenOption[0]), Charset.defaultCharset()));
    }
}

