/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.core.uri.expression.InfoMethod;

public class MethodExpressionImpl
implements MethodExpression {
    private InfoMethod infoMethod;
    private EdmType returnType;
    private List<CommonExpression> actualParameters;

    public MethodExpressionImpl(InfoMethod infoMethod) {
        this.infoMethod = infoMethod;
        this.returnType = infoMethod.getReturnType();
        this.actualParameters = new ArrayList<CommonExpression>();
    }

    public EdmType getEdmType() {
        return this.returnType;
    }

    public CommonExpression setEdmType(EdmType edmType) {
        this.returnType = edmType;
        return this;
    }

    public MethodOperator getMethod() {
        return this.infoMethod.getMethod();
    }

    public InfoMethod getMethodInfo() {
        return this.infoMethod;
    }

    public List<CommonExpression> getParameters() {
        return this.actualParameters;
    }

    public int getParameterCount() {
        return this.actualParameters.size();
    }

    public MethodExpressionImpl appendParameter(CommonExpression expression) {
        this.actualParameters.add(expression);
        return this;
    }

    public ExpressionKind getKind() {
        return ExpressionKind.METHOD;
    }

    public String getUriLiteral() {
        return this.infoMethod.getSyntax();
    }

    public Object accept(ExpressionVisitor visitor) throws ExceptionVisitExpression, ODataApplicationException {
        ArrayList<Object> retParameters = new ArrayList<Object>();
        for (CommonExpression parameter : this.actualParameters) {
            Object retParameter = parameter.accept(visitor);
            retParameters.add(retParameter);
        }
        Object ret = visitor.visitMethod((MethodExpression)this, this.getMethod(), retParameters);
        return ret;
    }
}

