/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.debug.DebugInfoBody;
import org.apache.olingo.odata2.core.debug.ODataDebugResponseWrapper;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class DebugInfoResponse
implements DebugInfo {
    private final ODataResponse response;
    private final String serviceRoot;
    private final HttpStatusCodes status;
    private final Map<String, String> headers;

    public DebugInfoResponse(ODataResponse response, String serviceRoot) {
        this.response = response;
        this.serviceRoot = serviceRoot;
        this.status = response.getStatus();
        this.headers = new HashMap<String, String>();
        for (String name : response.getHeaderNames()) {
            this.headers.put(name, response.getHeader(name));
        }
    }

    @Override
    public String getName() {
        return "Response";
    }

    @Override
    public void appendJson(JsonStreamWriter jsonStreamWriter) throws IOException {
        jsonStreamWriter.beginObject();
        if (this.status != null) {
            jsonStreamWriter.name("status").beginObject().name("code").unquotedValue(Integer.toString(this.status.getStatusCode())).separator().namedStringValueRaw("info", this.status.getInfo()).endObject();
        }
        if (!this.headers.isEmpty()) {
            if (this.status != null) {
                jsonStreamWriter.separator();
            }
            jsonStreamWriter.name("headers");
            ODataDebugResponseWrapper.appendJsonTable(jsonStreamWriter, this.headers);
        }
        if (this.response.getContentHeader() != null && this.response.getEntity() != null) {
            if (this.status != null || !this.headers.isEmpty()) {
                jsonStreamWriter.separator();
            }
            jsonStreamWriter.name("body");
            new DebugInfoBody(this.response, this.serviceRoot).appendJson(jsonStreamWriter);
        }
        jsonStreamWriter.endObject();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        writer.append("<h2>Status Code</h2>\n").append("<p>").append(Integer.toString(this.status.getStatusCode())).append(' ').append(this.status.getInfo()).append("</p>\n").append("<h2>Response Headers</h2>\n");
        ODataDebugResponseWrapper.appendHtmlTable(writer, this.headers);
        if (this.response.getContentHeader() != null && this.response.getEntity() != null) {
            writer.append("<h2>Response Body</h2>\n");
            new DebugInfoBody(this.response, this.serviceRoot).appendHtml(writer);
        }
    }
}

