/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.olingo.odata2.core.ep.util;

/**
 * String constants for formatting and parsing of XML.
 * 
 */
public class FormatXml {

  public static final String XML_HEADER_NO = "no";
  public static final String XML_HEADER_FULL = "full";
  public static final String XML_HEADER_WITHOUT_ENCODING = "without encoding";
  public static final String XML_BASE = "base";
  public static final String XML_LANG = "lang";

  public static final String M_PROPERTIES = "properties";
  public static final String M_MIME_TYPE = "MimeType";

  public static final String M_ETAG = "etag";
  public static final String M_COUNT = "count";
  public static final String M_TYPE = "type";
  public static final String M_NULL = "null";
  public static final String M_INLINE = "inline";

  public static final String M_ERROR = "error";
  public static final String M_SEVERITY = "severity";
  public static final String M_TARGET = "target";
  public static final String M_CODE = "code";
  public static final String M_MESSAGE = "message";
  public static final String M_INNER_ERROR = "innererror";
  public static final String M_ERROR_DETAILS = "errordetails";
  public static final String M_ERROR_DETAIL = "errordetail";

  public static final String D_ELEMENT = "element";
  public static final String D_LINKS = "links";
  public static final String D_URI = "uri";

  public static final String APP_SERVICE = "service";
  public static final String APP_WORKSPACE = "workspace";
  public static final String APP_COLLECTION = "collection";
  public static final String APP_ACCEPT = "accept";
  public static final String APP_CATEGORIES = "categories";
  public static final String APP_CATEGORIES_FIXED = "fixed";
  public static final String APP_CATEGORIES_SCHEME = "scheme";

  public static final String ATOM_FEED = "feed";
  public static final String ATOM_ENTRY = "entry";
  public static final String ATOM_LINK = "link";
  public static final String ATOM_REL = "rel";
  public static final String ATOM_HREF = "href";
  public static final String ATOM_SRC = "src";
  public static final String ATOM_TITLE = "title";
  public static final String ATOM_TITLE_DEFAULT = "Default";
  public static final String ATOM_TEXT = "text";
  public static final String ATOM_TYPE = "type";
  public static final String ATOM_UPDATED = "updated";
  public static final String ATOM_ID = "id";
  public static final String ATOM_AUTHOR = "author";
  public static final String ATOM_AUTHOR_NAME = "name";
  public static final String ATOM_AUTHOR_EMAIL = "email";
  public static final String ATOM_AUTHOR_URI = "uri";
  public static final String ATOM_SUMMARY = "summary";
  public static final String ATOM_CONTRIBUTOR = "contributor";
  public static final String ATOM_CONTRIBUTOR_NAME = "name";
  public static final String ATOM_CONTRIBUTOR_EMAIL = "email";
  public static final String ATOM_CONTRIBUTOR_URI = "uri";
  public static final String ATOM_PUBLISHED = "published";
  public static final String ATOM_RIGHTS = "rights";
  public static final String ATOM_CATEGORY = "category";
  public static final String ATOM_CATEGORY_TERM = "term";
  public static final String ATOM_CATEGORY_SCHEME = "scheme";
  public static final String ATOM_CATEGORY_LABEL = "label";
  public static final String ATOM_CONTENT = "content";
  public static final String ATOM_NULL = "null";
  public static final String ATOM_VALUE_TRUE = "true";
  public static final String ATOM_NEXT_LINK = "next";
  public static final String ATOM_DELTA_LINK = "delta";
  public static final String ATOM_TOMBSTONE_REF = "ref";
  public static final String ATOM_TOMBSTONE_WHEN = "when";
  public static final String ATOM_TOMBSTONE_DELETED_ENTRY = "deleted-entry";
  public static final String ATOM_TOMBSTONE_NAMESPACE = "http://purl.org/atompub/tombstones/1.0";
  public static final String ATOM_TOMBSTONE_PREFIX = "at";
}
