/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.EdmMetadataRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataDeltaRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntityRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntitySetIteratorRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataEntitySetRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataMediaRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataPropertyRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataRawRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataServiceDocumentRequest;
import org.apache.olingo.client.api.communication.request.retrieve.ODataValueRequest;
import org.apache.olingo.client.api.communication.request.retrieve.RetrieveRequestFactory;
import org.apache.olingo.client.api.communication.request.retrieve.XMLMetadataRequest;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientSingleton;
import org.apache.olingo.client.core.communication.request.retrieve.EdmMetadataRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataDeltaRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataEntityRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataEntitySetIteratorRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataEntitySetRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataMediaRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataPropertyRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataRawRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataServiceDocumentRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.ODataValueRequestImpl;
import org.apache.olingo.client.core.communication.request.retrieve.XMLMetadataRequestImpl;
import org.apache.olingo.client.core.uri.URIUtils;

public class RetrieveRequestFactoryImpl
implements RetrieveRequestFactory {
    protected final ODataClient client;

    public RetrieveRequestFactoryImpl(ODataClient client) {
        this.client = client;
    }

    public ODataValueRequest getValueRequest(URI uri) {
        return new ODataValueRequestImpl(this.client, uri);
    }

    public ODataValueRequest getPropertyValueRequest(URI uri) {
        return this.getValueRequest(URIUtils.addValueSegment(uri));
    }

    public ODataMediaRequest getMediaRequest(URI uri) {
        return new ODataMediaRequestImpl(this.client, uri);
    }

    public ODataMediaRequest getMediaEntityRequest(URI uri) {
        return this.getMediaRequest(URIUtils.addValueSegment(uri));
    }

    public ODataRawRequest getRawRequest(URI uri) {
        return new ODataRawRequestImpl(this.client, uri);
    }

    public EdmMetadataRequest getMetadataRequest(String serviceRoot) {
        return new EdmMetadataRequestImpl(this.client, serviceRoot, this.client.newURIBuilder(serviceRoot).appendMetadataSegment().build());
    }

    public ODataServiceDocumentRequest getServiceDocumentRequest(String serviceRoot) {
        return new ODataServiceDocumentRequestImpl(this.client, serviceRoot != null && !serviceRoot.isEmpty() && serviceRoot.endsWith("/") ? this.client.newURIBuilder(serviceRoot).build() : this.client.newURIBuilder(serviceRoot + '/').build());
    }

    public XMLMetadataRequest getXMLMetadataRequest(String serviceRoot) {
        return new XMLMetadataRequestImpl(this.client, this.client.newURIBuilder(serviceRoot).appendMetadataSegment().build());
    }

    public ODataEntitySetRequest<ClientEntitySet> getEntitySetRequest(URI uri) {
        return new ODataEntitySetRequestImpl<ClientEntitySet>(this.client, uri);
    }

    public ODataEntitySetIteratorRequest<ClientEntitySet, ClientEntity> getEntitySetIteratorRequest(URI uri) {
        return new ODataEntitySetIteratorRequestImpl<ClientEntitySet, ClientEntity>(this.client, uri);
    }

    public ODataEntityRequest<ClientSingleton> getSingletonRequest(URI uri) {
        return new ODataEntityRequestImpl<ClientSingleton>(this.client, uri);
    }

    public ODataEntityRequest<ClientEntity> getEntityRequest(URI uri) {
        return new ODataEntityRequestImpl<ClientEntity>(this.client, uri);
    }

    public ODataPropertyRequest<ClientProperty> getPropertyRequest(URI uri) {
        return new ODataPropertyRequestImpl<ClientProperty>(this.client, uri);
    }

    public ODataDeltaRequest getDeltaRequest(URI uri) {
        return new ODataDeltaRequestImpl(this.client, uri);
    }
}

