/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPacketWriter;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioStream;
import org.gagravarr.vorbis.VorbisAudioData;
import org.gagravarr.vorbis.VorbisComments;
import org.gagravarr.vorbis.VorbisInfo;
import org.gagravarr.vorbis.VorbisPacket;
import org.gagravarr.vorbis.VorbisPacketFactory;
import org.gagravarr.vorbis.VorbisSetup;

public class VorbisFile
implements OggAudioStream,
OggAudioHeaders,
Closeable {
    private OggFile ogg;
    private OggPacketReader r;
    private OggPacketWriter w;
    private int sid = -1;
    private VorbisInfo info;
    private VorbisComments comment;
    private VorbisSetup setup;
    private List<VorbisAudioData> writtenPackets;

    public VorbisFile(File f) throws IOException, FileNotFoundException {
        this(new OggFile(new FileInputStream(f)));
    }

    public VorbisFile(OggFile ogg) throws IOException {
        this(ogg.getPacketReader());
        this.ogg = ogg;
    }

    public VorbisFile(OggPacketReader r) throws IOException {
        this.r = r;
        OggPacket p = null;
        while ((p = r.getNextPacket()) != null) {
            if (!p.isBeginningOfStream() || p.getData().length <= 10 || !VorbisPacketFactory.isVorbisStream(p)) continue;
            this.sid = p.getSid();
            break;
        }
        if (p == null) {
            throw new IllegalArgumentException("Supplied File is not Vorbis");
        }
        this.info = (VorbisInfo)VorbisPacketFactory.create(p);
        this.comment = (VorbisComments)VorbisPacketFactory.create(r.getNextPacketWithSid(this.sid));
        this.setup = (VorbisSetup)VorbisPacketFactory.create(r.getNextPacketWithSid(this.sid));
    }

    public VorbisFile(OutputStream out) {
        this(out, new VorbisInfo(), new VorbisComments(), new VorbisSetup());
    }

    public VorbisFile(OutputStream out, VorbisInfo info, VorbisComments comments, VorbisSetup setup) {
        this(out, -1, info, comments, setup);
    }

    public VorbisFile(OutputStream out, int sid, VorbisInfo info, VorbisComments comments, VorbisSetup setup) {
        this.ogg = new OggFile(out);
        if (sid > 0) {
            this.w = this.ogg.getPacketWriter(sid);
            this.sid = sid;
        } else {
            this.w = this.ogg.getPacketWriter();
            this.sid = this.w.getSid();
        }
        this.writtenPackets = new ArrayList<VorbisAudioData>();
        this.info = info;
        this.comment = comments;
        this.setup = setup;
    }

    public VorbisAudioData getNextAudioPacket() throws IOException {
        OggPacket p = null;
        VorbisPacket vp = null;
        while ((p = this.r.getNextPacketWithSid(this.sid)) != null) {
            vp = VorbisPacketFactory.create(p);
            if (vp instanceof VorbisAudioData) {
                return (VorbisAudioData)vp;
            }
            System.err.println("Skipping non audio packet " + vp + " mid audio stream");
        }
        return null;
    }

    public void skipToGranule(long granulePosition) throws IOException {
        this.r.skipToGranulePosition(this.sid, granulePosition);
    }

    public int getSid() {
        return this.sid;
    }

    public OggStreamIdentifier.OggStreamType getType() {
        return OggStreamIdentifier.OGG_VORBIS;
    }

    public VorbisInfo getInfo() {
        return this.info;
    }

    public VorbisComments getComment() {
        return this.comment;
    }

    public VorbisComments getTags() {
        return this.comment;
    }

    public VorbisSetup getSetup() {
        return this.setup;
    }

    public void writeAudioData(VorbisAudioData data) {
        this.writtenPackets.add(data);
    }

    public void close() throws IOException {
        if (this.r != null) {
            this.r = null;
            this.ogg.close();
            this.ogg = null;
        }
        if (this.w != null) {
            this.w.bufferPacket(this.info.write(), true);
            this.w.bufferPacket(this.comment.write(), false);
            this.w.bufferPacket(this.setup.write(), true);
            long lastGranule = 0L;
            for (VorbisAudioData vd : this.writtenPackets) {
                if (vd.getGranulePosition() >= 0L && lastGranule != vd.getGranulePosition()) {
                    this.w.flush();
                    lastGranule = vd.getGranulePosition();
                    this.w.setGranulePosition(lastGranule);
                }
                this.w.bufferPacket(vd.write());
                if (this.w.getSizePendingFlush() <= 16384) continue;
                this.w.flush();
            }
            this.w.close();
            this.w = null;
            this.ogg.close();
            this.ogg = null;
        }
    }

    public OggFile getOggFile() {
        return this.ogg;
    }
}

