/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common;

import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.web.common.OmPagingNavigator;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class PagingNavigatorPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private int entitiesPerPage;
    private final DataView<?> dataView;
    private final List<Integer> numbers;

    protected PagingNavigatorPanel(String id, DataView<?> dataView) {
        this(id, dataView, List.of(Integer.valueOf(10), Integer.valueOf(25), Integer.valueOf(50), Integer.valueOf(75), Integer.valueOf(100), Integer.valueOf(200)), 50);
    }

    protected PagingNavigatorPanel(String id, DataView<?> dataView, List<Integer> numbers, int entitiesPerPage) {
        super(id);
        this.setOutputMarkupId(true);
        this.entitiesPerPage = entitiesPerPage;
        this.dataView = dataView;
        this.numbers = numbers;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.dataView.setItemsPerPage((long)this.entitiesPerPage);
        Form f = new Form("pagingForm");
        f.add(new Component[]{new OmPagingNavigator("navigator", (IPageable)this.dataView).setOutputMarkupId(true)}).add(new Component[]{new DropDownChoice("entitiesPerPage", (IModel)new PropertyModel((Object)this, "entitiesPerPage"), this.numbers).add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> {
            long newPage = this.dataView.getCurrentPage() * this.dataView.getItemsPerPage() / (long)this.entitiesPerPage;
            this.dataView.setItemsPerPage((long)this.entitiesPerPage);
            this.dataView.setCurrentPage(newPage);
            target.add(new Component[]{f});
            this.onEvent((AjaxRequestTarget)target);
        })})});
        this.add(new Component[]{f.setOutputMarkupId(true)});
    }

    public int getEntitiesPerPage() {
        return this.entitiesPerPage;
    }

    public void setEntitiesPerPage(int entitiesPerPage) {
        this.entitiesPerPage = entitiesPerPage;
    }

    protected abstract void onEvent(AjaxRequestTarget var1);
}

