/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.profile;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.spinner.SpinnerAjaxButton;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.app.OtpManager;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.pages.auth.SignInDialog;
import org.apache.openmeetings.web.user.profile.EditProfileForm;
import org.apache.openmeetings.web.user.profile.EditProfilePanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.Strings;

public class ToggleOtpDialog
extends Modal<User> {
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final PasswordTextField current = new PasswordTextField("current", (IModel)Model.of((Serializable)((Object)((String)null))));
    private final WebMarkupContainer qr = new WebMarkupContainer("qr");
    private final TextArea<String> codesArea = new TextArea("codes", (IModel)Model.of((Serializable)((Object)"")));
    private String secret;
    private String[] codes;
    @Inject
    private OtpManager otpManager;
    @Inject
    private UserDao userDao;

    public ToggleOtpDialog(String id) {
        super(id);
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("otp.enable"));
        this.setUseCloseHandler(true);
        Form<String> form = new Form<String>("form"){
            private static final long serialVersionUID = 1L;

            protected void onValidate() {
                User u = (User)ToggleOtpDialog.this.getModelObject();
                String p = (String)ToggleOtpDialog.this.current.getConvertedInput();
                if (!Strings.isEmpty((String)p) && !ToggleOtpDialog.this.userDao.verifyPassword(u.getId(), p)) {
                    this.error((Serializable)((Object)this.getString("231")));
                    SignInDialog.penalty();
                }
                super.onValidate();
            }
        };
        this.add(new Component[]{form.add(new Component[]{this.current.setLabel((IModel)new ResourceModel("current.password")).setOutputMarkupId(true)}).add(new Component[]{this.qr.setOutputMarkupId(true)}).add(new Component[]{this.codesArea.setOutputMarkupId(true)}).add(new Component[]{this.feedback.setOutputMarkupId(true)})});
        this.addButton((Component)new SpinnerAjaxButton("button", (IModel)new ResourceModel("otp.enable"), (Form)form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{ToggleOtpDialog.this.feedback});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                User u = (User)ToggleOtpDialog.this.getModelObject();
                u.setOtpSecret(ToggleOtpDialog.this.secret);
                u.setOtpRecoveryCodes(String.join((CharSequence)" ", ToggleOtpDialog.this.codes));
                EditProfileForm editForm = (EditProfileForm)((EditProfilePanel)((Object)this.findParent(EditProfilePanel.class))).get("form");
                editForm.updateOtpButton(true, (IPartialPageRequestHandler)target);
                ToggleOtpDialog.this.userDao.update(u, u.getId());
                ToggleOtpDialog.this.close((IPartialPageRequestHandler)target);
            }
        });
        this.addButton((Component)OmModalCloseButton.of());
        super.onInitialize();
    }

    public void onClose(IPartialPageRequestHandler handler) {
        this.secret = null;
        this.current.setModelObject(null);
        this.qr.add(new Behavior[]{AttributeModifier.remove((String)"src")});
        this.codesArea.setModelObject((Object)"");
        handler.add(new Component[]{this.current, this.qr, this.codesArea});
    }

    public Modal<User> show(IPartialPageRequestHandler target) {
        this.secret = this.otpManager.generateSecret();
        this.codes = this.otpManager.getRecoveryCodes();
        User u = (User)this.getModelObject();
        this.current.setModelObject(null);
        this.qr.add(new Behavior[]{AttributeModifier.replace((String)"src", (Serializable)((Object)this.otpManager.getQr(u.getAddress().getEmail(), this.secret)))});
        this.codesArea.setModelObject((Object)String.join((CharSequence)"\n", this.codes));
        target.add(new Component[]{this.current, this.qr, this.codesArea});
        return super.show(target);
    }
}

