/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.WebRowSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderImpl;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriterImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleWebRowSet
extends OracleCachedRowSet
implements WebRowSet {
    static final long serialVersionUID = 617253792409477080L;
    private transient OracleWebRowSetXmlReader xmlReader = new OracleWebRowSetXmlReaderImpl();
    private transient OracleWebRowSetXmlWriter xmlWriter = new OracleWebRowSetXmlWriterImpl();

    public OracleWebRowSet() throws SQLException {
        this.setReadOnly(false);
    }

    @Override
    public void readXml(Reader reader) throws SQLException {
        if (this.xmlReader == null) {
            throw (SQLException)DatabaseError.createSqlException(355).fillInStackTrace();
        }
        this.xmlReader.readXML(this, reader);
    }

    @Override
    public void writeXml(Writer writer) throws SQLException {
        if (this.xmlWriter == null) {
            throw (SQLException)DatabaseError.createSqlException(356).fillInStackTrace();
        }
        this.xmlWriter.writeXML(this, writer);
    }

    @Override
    public void writeXml(ResultSet resultSet, Writer writer) throws SQLException {
        this.populate(resultSet);
        this.writeXml(writer);
    }

    @Override
    public void readXml(InputStream inputStream) throws SQLException {
        this.readXml(new InputStreamReader(inputStream));
    }

    @Override
    public void writeXml(OutputStream outputStream) throws SQLException {
        this.writeXml(new OutputStreamWriter(outputStream));
    }

    @Override
    public void writeXml(ResultSet resultSet, OutputStream outputStream) throws SQLException {
        this.writeXml(resultSet, new OutputStreamWriter(outputStream));
    }
}

