/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.console;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.client.console.ClientConsoleApp;
import com.hazelcast.client.console.SqlConsole;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.impl.management.MCClusterMetadata;
import com.hazelcast.client.impl.protocol.codec.MCGetClusterMetadataCodec;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.impl.HazelcastBootstrap;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.version.Version;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogManager;
import picocli.CommandLine;

@CommandLine.Command(name="hz-cli", description={"Utility to perform operations on a Hazelcast cluster.%nBy default it uses the file config/hazelcast-client.xml to configure the client connection.%n%nGlobal options are:%n"}, versionProvider=HazelcastVersionProvider.class, mixinStandardHelpOptions=true, sortOptions=false, subcommands={CommandLine.HelpCommand.class})
public class HazelcastCommandLine
implements Runnable {
    private static final int MAX_STR_LENGTH = 24;
    private static final int WAIT_INTERVAL_MILLIS = 100;
    private final Function<ClientConfig, HazelcastInstance> hzClientFn;
    private final PrintStream out;
    private final PrintStream err;
    @CommandLine.Option(names={"-f", "--config"}, description={"Optional path to a client config XML/YAML file. The default is to use config/hazelcast-client.xml."}, order=0)
    private File config;
    @CommandLine.Mixin
    private GlobalMixin global;

    public HazelcastCommandLine(Function<ClientConfig, HazelcastInstance> hzClientFn, PrintStream out, PrintStream err) {
        this.hzClientFn = hzClientFn;
        this.out = out;
        this.err = err;
    }

    public static void main(String[] args) {
        HazelcastCommandLine.runCommandLine(HazelcastClient::newHazelcastClient, System.out, System.err, true, args);
    }

    @Override
    public void run() {
    }

    @CommandLine.Command(description={"Starts the SQL shell [BETA]"})
    public void sql(@CommandLine.Mixin GlobalMixin global) {
        this.runWithHazelcast(global, true, hz -> {
            SqlConsole sqlConsole = new SqlConsole(this.global, (HazelcastInstance)hz);
            sqlConsole.run();
        });
    }

    @CommandLine.Command(description={"Submits a job to the cluster"})
    public void submit(@CommandLine.Mixin GlobalMixin global, @CommandLine.Option(names={"-s", "--snapshot"}, paramLabel="<snapshot name>", description={"Name of the initial snapshot to start the job from"}) String snapshotName, @CommandLine.Option(names={"-n", "--name"}, paramLabel="<name>", description={"Name of the job"}) String name, @CommandLine.Option(names={"-c", "--class"}, paramLabel="<class>", description={"Fully qualified name of the main class inside the JAR file"}) String mainClass, @CommandLine.Parameters(index="0", paramLabel="<jar file>", description={"The jar file to submit"}) File file, @CommandLine.Parameters(index="1..*", paramLabel="<arguments>", description={"Arguments to pass to the supplied jar file"}) List<String> params) throws IOException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (params == null) {
            params = Collections.emptyList();
        }
        this.global.merge(global);
        this.configureLogging();
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file + " could not be found.");
        }
        this.printf("Submitting JAR '%s' with arguments %s", file, params);
        if (name != null) {
            this.printf("Using job name '%s'", name);
        }
        if (snapshotName != null) {
            this.printf("Will restore the job from the snapshot with name '%s'", snapshotName);
        }
        HazelcastBootstrap.executeJarOnCLI(() -> this.getHazelcastClient(false), file.getAbsolutePath(), snapshotName, name, mainClass, params);
    }

    @CommandLine.Command(name="console", description={"Starts the console application for trying out in-memory data structures of Hazelcast. It is not recommended for use in production."})
    public void consoleApp(@CommandLine.Mixin GlobalMixin global) {
        this.runWithHazelcast(global, true, ClientConsoleApp::run);
    }

    @CommandLine.Command(description={"Suspends a running job"})
    public void suspend(@CommandLine.Mixin GlobalMixin global, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to suspend"}) String name) {
        this.runWithHazelcast(global, false, hz -> {
            Job job = HazelcastCommandLine.getJob(hz, name);
            HazelcastCommandLine.assertJobRunning(name, job);
            this.printf("Suspending job %s...", HazelcastCommandLine.formatJob(job));
            job.suspend();
            HazelcastCommandLine.waitForJobStatus(job, JobStatus.SUSPENDED);
            this.println("Job suspended.");
        });
    }

    @CommandLine.Command(description={"Cancels a running job"})
    public void cancel(@CommandLine.Mixin GlobalMixin global, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to cancel"}) String name) {
        this.runWithHazelcast(global, false, hz -> {
            Job job = HazelcastCommandLine.getJob(hz, name);
            HazelcastCommandLine.assertJobActive(name, job);
            this.printf("Cancelling job %s", HazelcastCommandLine.formatJob(job));
            job.cancel();
            HazelcastCommandLine.waitForJobStatus(job, JobStatus.FAILED);
            this.println("Job cancelled.");
        });
    }

    @CommandLine.Command(name="save-snapshot", description={"Exports a named snapshot from a job and optionally cancels it"})
    public void saveSnapshot(@CommandLine.Mixin GlobalMixin global, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to take the snapshot from"}) String jobName, @CommandLine.Parameters(index="1", paramLabel="<snapshot name>", description={"Name of the snapshot"}) String snapshotName, @CommandLine.Option(names={"-C", "--cancel"}, description={"Cancel the job after taking the snapshot"}) boolean isTerminal) {
        this.runWithHazelcast(global, false, hz -> {
            Job job = HazelcastCommandLine.getJob(hz, jobName);
            HazelcastCommandLine.assertJobActive(jobName, job);
            if (isTerminal) {
                this.printf("Saving snapshot with name '%s' from job '%s' and cancelling the job...", snapshotName, HazelcastCommandLine.formatJob(job));
                job.cancelAndExportSnapshot(snapshotName);
                HazelcastCommandLine.waitForJobStatus(job, JobStatus.FAILED);
            } else {
                this.printf("Saving snapshot with name '%s' from job '%s'...", snapshotName, HazelcastCommandLine.formatJob(job));
                job.exportSnapshot(snapshotName);
            }
            this.printf("Exported snapshot '%s'.", snapshotName);
        });
    }

    @CommandLine.Command(name="delete-snapshot", description={"Deletes a named snapshot"})
    public void deleteSnapshot(@CommandLine.Mixin GlobalMixin global, @CommandLine.Parameters(index="0", paramLabel="<snapshot name>", description={"Name of the snapshot"}) String snapshotName) {
        this.runWithHazelcast(global, false, hz -> {
            JobStateSnapshot jobStateSnapshot = hz.getJet().getJobStateSnapshot(snapshotName);
            if (jobStateSnapshot == null) {
                throw new JetException(String.format("Didn't find a snapshot named '%s'", snapshotName));
            }
            jobStateSnapshot.destroy();
            this.printf("Deleted snapshot '%s'.", snapshotName);
        });
    }

    @CommandLine.Command(description={"Restarts a running job"})
    public void restart(@CommandLine.Mixin GlobalMixin global, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to restart"}) String name) {
        this.runWithHazelcast(global, false, hz -> {
            Job job = HazelcastCommandLine.getJob(hz, name);
            HazelcastCommandLine.assertJobRunning(name, job);
            this.println("Restarting job " + HazelcastCommandLine.formatJob(job) + "...");
            job.restart();
            HazelcastCommandLine.waitForJobStatus(job, JobStatus.RUNNING);
            this.println("Job restarted.");
        });
    }

    @CommandLine.Command(description={"Resumes a suspended job"})
    public void resume(@CommandLine.Mixin GlobalMixin global, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to resume"}) String name) {
        this.runWithHazelcast(global, false, hz -> {
            Job job = HazelcastCommandLine.getJob(hz, name);
            if (job.getStatus() != JobStatus.SUSPENDED) {
                throw new RuntimeException("Job '" + name + "' is not suspended. Current state: " + job.getStatus());
            }
            this.println("Resuming job " + HazelcastCommandLine.formatJob(job) + "...");
            job.resume();
            HazelcastCommandLine.waitForJobStatus(job, JobStatus.RUNNING);
            this.println("Job resumed.");
        });
    }

    @CommandLine.Command(name="list-jobs", description={"Lists running jobs on the cluster"})
    public void listJobs(@CommandLine.Mixin GlobalMixin global, @CommandLine.Option(names={"-a", "--all"}, description={"Lists all jobs including completed and failed ones"}) boolean listAll) {
        this.runWithHazelcast(global, false, hz -> {
            JetClientInstanceImpl jetClientInstanceImpl = (JetClientInstanceImpl)hz.getJet();
            List<JobSummary> summaries = jetClientInstanceImpl.getJobSummaryList();
            String format = "%-19s %-18s %-23s %s";
            this.printf(format, "ID", "STATUS", "SUBMISSION TIME", "NAME");
            summaries.stream().filter(job -> listAll || HazelcastCommandLine.isActive(job.getStatus())).forEach(job -> {
                String idString = com.hazelcast.jet.Util.idToString(job.getJobId());
                String name = job.getNameOrId().equals(idString) ? "N/A" : job.getNameOrId();
                this.printf(format, new Object[]{idString, job.getStatus(), Util.toLocalDateTime(job.getSubmissionTime()), name});
            });
        });
    }

    @CommandLine.Command(name="list-snapshots", description={"Lists exported snapshots on the cluster"})
    public void listSnapshots(@CommandLine.Mixin GlobalMixin global, @CommandLine.Option(names={"-F", "--full-job-name"}, description={"Don't trim job name to fit, can break layout"}) boolean fullJobName) {
        this.runWithHazelcast(global, false, hz -> {
            Collection<JobStateSnapshot> snapshots = hz.getJet().getJobStateSnapshots();
            this.printf("%-23s %-15s %-24s %s", "TIME", "SIZE (bytes)", "JOB NAME", "SNAPSHOT NAME");
            snapshots.stream().sorted(Comparator.comparing(JobStateSnapshot::name)).forEach(ss -> {
                String jobName;
                LocalDateTime creationTime = Util.toLocalDateTime(ss.creationTime());
                String string = jobName = ss.jobName() == null ? com.hazelcast.jet.Util.idToString(ss.jobId()) : ss.jobName();
                if (!fullJobName) {
                    jobName = HazelcastCommandLine.shorten(jobName);
                }
                this.printf("%-23s %-,15d %-24s %s", creationTime, ss.payloadSize(), jobName, ss.name());
            });
        });
    }

    @CommandLine.Command(description={"Shows current cluster state and information about members"})
    public void cluster(@CommandLine.Mixin GlobalMixin global) {
        this.runWithHazelcast(global, false, hz -> {
            HazelcastClientInstanceImpl hazelcastClientImpl = HazelcastCommandLine.getHazelcastClientInstanceImpl(hz);
            ClientClusterService clientClusterService = hazelcastClientImpl.getClientClusterService();
            MCClusterMetadata clusterMetadata = FutureUtil.getValue(HazelcastCommandLine.getClusterMetadata(hazelcastClientImpl, clientClusterService.getMasterMember()));
            Cluster cluster = hazelcastClientImpl.getCluster();
            this.println("State: " + clusterMetadata.getCurrentState());
            this.println("Version: " + clusterMetadata.getMemberVersion());
            this.println("Size: " + cluster.getMembers().size());
            this.println("");
            String format = "%-24s %-19s";
            this.printf(format, "ADDRESS", "UUID");
            cluster.getMembers().forEach(member -> this.printf(format, member.getAddress(), member.getUuid()));
        });
    }

    protected static CompletableFuture<MCClusterMetadata> getClusterMetadata(HazelcastClientInstanceImpl client, Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation((HazelcastClientInstance)client, MCGetClusterMetadataCodec.encodeRequest(), null, member.getUuid());
        return new ClientDelegatingFuture<MCClusterMetadata>(invocation.invoke(), client.getSerializationService(), clientMessage -> {
            MCGetClusterMetadataCodec.ResponseParameters response = MCGetClusterMetadataCodec.decodeResponse(clientMessage);
            MCClusterMetadata metadata = new MCClusterMetadata();
            metadata.setCurrentState(ClusterState.getById(response.currentState));
            metadata.setClusterTime(response.clusterTime);
            metadata.setMemberVersion(response.memberVersion);
            return metadata;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithHazelcast(GlobalMixin global, boolean retryClusterConnectForever, ConsumerEx<HazelcastInstance> consumer) {
        this.global.merge(global);
        this.configureLogging();
        HazelcastInstance hz = this.getHazelcastClient(retryClusterConnectForever);
        try {
            consumer.accept(hz);
        }
        finally {
            hz.shutdown();
        }
    }

    private HazelcastInstance getHazelcastClient(boolean retryClusterConnectForever) {
        return Util.uncheckCall(() -> {
            HazelcastInstance client = this.hzClientFn.apply(this.getClientConfig(retryClusterConnectForever));
            if (!this.global.ignoreVersionMismatch) {
                this.checkVersionCompatibility(client);
            }
            return client;
        });
    }

    private void checkVersionCompatibility(HazelcastInstance client) {
        HazelcastClientInstanceImpl clientImpl = HazelcastCommandLine.getHazelcastClientInstanceImpl(client);
        MemberVersion masterVersion = clientImpl.getClientClusterService().getMasterMember().getVersion();
        String fullClientVersion = BuildInfoProvider.getBuildInfo().getVersion();
        Version clientVersion = Version.of(fullClientVersion);
        if (!masterVersion.asVersion().equals(clientVersion)) {
            throw new HazelcastException("Server and client must have matching minor version. Server version " + masterVersion + ", hz-cli version " + fullClientVersion);
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Generates false positive")
    private ClientConfig getClientConfig(boolean retryClusterConnectForever) throws IOException {
        ClientConfig clientConfig = this.isYaml() ? new YamlClientConfigBuilder(this.config).build() : (this.isConfigFileNotNull() ? new XmlClientConfigBuilder(this.config).build() : ClientConfig.load());
        if (this.global.getTargets() != null) {
            clientConfig.getNetworkConfig().setAddresses(this.global.getAddresses());
            clientConfig.setClusterName(this.global.getClusterName());
        }
        if (retryClusterConnectForever) {
            double expBackoffMultiplier = 1.25;
            long clusterConnectTimeoutMillis = Long.MAX_VALUE;
            int maxBackOffMillis = (int)TimeUnit.SECONDS.toMillis(15L);
            clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig().setClusterConnectTimeoutMillis(Long.MAX_VALUE).setMultiplier(1.25).setMaxBackoffMillis(maxBackOffMillis);
        }
        return clientConfig;
    }

    private boolean isYaml() {
        return this.isConfigFileNotNull() && (this.config.getPath().endsWith(".yaml") || this.config.getPath().endsWith(".yml"));
    }

    private boolean isConfigFileNotNull() {
        return this.config != null;
    }

    private void configureLogging() {
        HazelcastBootstrap.configureLogging();
        Level logLevel = Level.WARNING;
        if (this.global.isVerbose) {
            this.println("Verbose mode is on, setting logging level to INFO");
            logLevel = Level.INFO;
        }
        LogManager.getLogManager().getLogger("").setLevel(logLevel);
    }

    private void printf(String format, Object ... objects) {
        this.out.printf(format + "%n", objects);
    }

    private void println(String msg) {
        this.out.println(msg);
    }

    static void runCommandLine(Function<ClientConfig, HazelcastInstance> hzClientFn, PrintStream out, PrintStream err, boolean shouldExit, String[] args) {
        CommandLine cmd = new CommandLine((Object)new HazelcastCommandLine(hzClientFn, out, err));
        ((CommandLine)cmd.getSubcommands().get("submit")).setStopAtPositional(true);
        String version = BuildInfoProvider.getBuildInfo().getVersion();
        cmd.getCommandSpec().usageMessage().header(new String[]{"Hazelcast " + version});
        if (args.length == 0) {
            cmd.usage(out);
        } else {
            List parsed;
            CommandLine.DefaultExceptionHandler excHandler = (CommandLine.DefaultExceptionHandler)((CommandLine.DefaultExceptionHandler)new ExceptionHandler().useErr(err)).useAnsi(CommandLine.Help.Ansi.AUTO);
            if (shouldExit) {
                excHandler.andExit(1);
            }
            if ((parsed = (List)cmd.parseWithHandlers((CommandLine.IParseResultHandler2)((CommandLine.AbstractParseResultHandler)new CommandLine.RunAll().useOut(out)).useAnsi(CommandLine.Help.Ansi.AUTO), (CommandLine.IExceptionHandler2)excHandler, args)) != null && parsed.size() == 1) {
                cmd.usage(out);
            }
        }
    }

    private static Job getJob(HazelcastInstance hz, String nameOrId) {
        Job job = hz.getJet().getJob(nameOrId);
        if (job == null && (job = hz.getJet().getJob(com.hazelcast.jet.Util.idFromString(nameOrId))) == null) {
            throw new JobNotFoundException("No job with name or id '" + nameOrId + "' was found");
        }
        return job;
    }

    private static String shorten(String name) {
        if (name.length() <= 24) {
            return name;
        }
        return name.substring(0, 23) + "*";
    }

    private static String formatJob(Job job) {
        return "id=" + com.hazelcast.jet.Util.idToString(job.getId()) + ", name=" + job.getName() + ", submissionTime=" + Util.toLocalDateTime(job.getSubmissionTime());
    }

    private static void assertJobActive(String name, Job job) {
        if (!HazelcastCommandLine.isActive(job.getStatus())) {
            throw new RuntimeException("Job '" + name + "' is not active. Current state: " + job.getStatus());
        }
    }

    private static void assertJobRunning(String name, Job job) {
        if (job.getStatus() != JobStatus.RUNNING) {
            throw new RuntimeException("Job '" + name + "' is not running. Current state: " + job.getStatus());
        }
    }

    private static void waitForJobStatus(Job job, JobStatus status) {
        while (job.getStatus() != status) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
    }

    private static boolean isActive(JobStatus status) {
        return status != JobStatus.FAILED && status != JobStatus.COMPLETED;
    }

    protected static HazelcastClientInstanceImpl getHazelcastClientInstanceImpl(HazelcastInstance client) {
        if (client instanceof HazelcastClientProxy) {
            HazelcastClientProxy proxy = (HazelcastClientProxy)client;
            return proxy.client;
        }
        if (client instanceof HazelcastClientInstanceImpl) {
            HazelcastClientInstanceImpl impl = (HazelcastClientInstanceImpl)client;
            return impl;
        }
        throw new IllegalArgumentException("This method can be called only with client instances such as HazelcastClientProxy and HazelcastClientInstanceImpl.");
    }

    public static class GlobalMixin {
        @CommandLine.Option(names={"-v", "--verbosity"}, description={"Show verbose logs and full stack trace of errors"}, order=1)
        private boolean isVerbose;
        @CommandLine.Option(names={"--ignore-version-mismatch"}, description={"Ignore check between client and server versions (by default they must have matching minor version)"}, defaultValue="false")
        private boolean ignoreVersionMismatch;
        @CommandLine.Option(names={"-t", "--targets"}, description={"The cluster name and addresses to use if you want to connect to a cluster other than the one configured in the configuration file. At least one address is required. The cluster name is optional."}, paramLabel="[<cluster-name>@]<hostname>:<port>[,<hostname>:<port>]", converter={TargetsConverter.class})
        private Targets targets;

        public boolean isVerbose() {
            return this.isVerbose;
        }

        private Targets getTargets() {
            return this.targets;
        }

        public String getClusterName() {
            return this.targets.clusterName;
        }

        public List<String> getAddresses() {
            return this.targets.addresses;
        }

        void merge(GlobalMixin other) {
            this.isVerbose |= other.isVerbose;
            this.ignoreVersionMismatch |= other.ignoreVersionMismatch;
            if (other.getTargets() != null) {
                this.targets = other.getTargets();
            }
        }

        public static class Targets {
            private String clusterName = "dev";
            private List<String> addresses = Collections.emptyList();
        }

        public static class TargetsConverter
        implements CommandLine.ITypeConverter<Targets> {
            public Targets convert(String value) {
                Targets targets = new Targets();
                if (value == null) {
                    return targets;
                }
                if (value.contains("@")) {
                    String[] values = value.split("@");
                    targets.clusterName = values[0];
                    targets.addresses = Arrays.asList(values[1].split(","));
                } else {
                    targets.addresses = Arrays.asList(value.split(","));
                }
                return targets;
            }
        }
    }

    static class ExceptionHandler<R>
    extends CommandLine.DefaultExceptionHandler<R> {
        ExceptionHandler() {
        }

        public R handleExecutionException(CommandLine.ExecutionException ex, CommandLine.ParseResult parseResult) {
            CommandLine cmdLine = ex.getCommandLine();
            while (cmdLine.getParent() != null) {
                cmdLine = cmdLine.getParent();
            }
            HazelcastCommandLine hzCmd = (HazelcastCommandLine)cmdLine.getCommand();
            if (hzCmd.global.isVerbose) {
                ex.printStackTrace(super.err());
            } else {
                super.err().println("ERROR: " + ExceptionHandler.peel(ex.getCause()).getMessage());
                super.err().println();
                super.err().println("To see the full stack trace, re-run with the -v/--verbosity option");
            }
            if (this.hasExitCode()) {
                this.exit(this.exitCode());
            }
            throw ex;
        }

        static Throwable peel(Throwable e) {
            if (e instanceof InvocationTargetException) {
                return e.getCause();
            }
            return e;
        }
    }

    public static class HazelcastVersionProvider
    implements CommandLine.IVersionProvider {
        public String[] getVersion() {
            BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
            return new String[]{"Hazelcast " + buildInfo.getVersion(), "Revision " + buildInfo.getRevision(), "Build " + buildInfo.getBuild()};
        }
    }
}

